/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.EverythingAllowedAuthorizationCheckContextWithUserId;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.common.business.events.JCEventBus;
import de.justsoftware.onx.common.integration.persistence.DAOException;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeEditModel;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.business.EntityVersionImportService;
import de.justsoftware.onx.container.business.model.EntityVersion;
import de.justsoftware.onx.container.shared.i18n.EntityVersionConstants;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.EntityVersionId;
import de.justsoftware.onx.container.shared.model.EntityVersionReleaseClientModel;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.model.db.DBEntityLink;
import de.justsoftware.onx.events.EntityUpdateEvent;
import de.justsoftware.onx.events.business.UpdateEventHandler;
import de.justsoftware.onx.mail.business.ImportResultMailService;
import de.justsoftware.onx.migration.business.EntityImportReviewHelper;
import de.justsoftware.onx.migration.business.EntityImportService;
import de.justsoftware.onx.migration.business.ImportException;
import de.justsoftware.onx.migration.business.ImportProcessLockService;
import de.justsoftware.onx.migration.business.impl.AbstractImportServiceImpl;
import de.justsoftware.onx.migration.business.impl.EntityImportReviewHelperImpl;
import de.justsoftware.onx.migration.business.impl.ImportUpdateEventCollector;
import de.justsoftware.onx.migration.business.model.ImportStatistics;
import de.justsoftware.onx.migration.integration.persistence.EntityImportDAO;
import de.justsoftware.onx.migration.shared.server.model.EntityImportBean;
import de.justsoftware.onx.migration.shared.server.model.EntityImportModel;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.validation.shared.model.JucoConstraintViolation;
import de.justsoftware.onx.validation.shared.model.JucoConstraintViolationException;
import de.justsoftware.toolbox.clock.Clock;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.jmx.export.annotation.ManagedOperation;

@ParametersAreNonnullByDefault
public abstract class AbstractEntityImportServiceImpl<T, E extends EntityImportModel<T>>
extends AbstractImportServiceImpl<E>
implements EntityImportService {
    @Autowired
    protected EntityService _entityService;
    protected EntityType _type;
    private final Supplier<TenantId> _tenantIdSupplier;
    @Autowired
    private EntityConfigService _entityConfigService;
    @Autowired
    private EntityVersionImportService _entityVersionService;
    @Autowired
    private Settings _settings;
    @Autowired
    private I18nService _i18nService;
    private ImmutableSet<EntityId> _linkedEntitiesIds = ImmutableSet.of();
    private ImmutableList<DBEntityLink> _linkedEntities;
    @CheckForNull
    private PersonId _defaultAdminId;
    @CheckForNull
    private PersonId _entityVersionAuthor;
    private ImmutableList<PersonId> _reviewers = ImmutableList.of();

    public AbstractEntityImportServiceImpl(PersonService personService, UpdateEventHandler updateEventHandler, JCEventBus eventBus, Clock clock, ImportResultMailService importResultMailService, ImportProcessLockService importProcessLockService, Supplier<TenantId> tenantIdSupplier) {
        super(personService, updateEventHandler, eventBus, clock, importResultMailService, importProcessLockService);
        this._tenantIdSupplier = tenantIdSupplier;
    }

    @Required
    public void setEntityType(@Nullable String type) {
        this._type = EntityType.getEntityTypeByName(type);
    }

    public void setEntityService(EntityService entityService) {
        this._entityService = entityService;
    }

    public void setEntityConfigService(EntityConfigService entityConfigService) {
        this._entityConfigService = entityConfigService;
    }

    public void setEntityVersionImportService(EntityVersionImportService entityVersionImportService) {
        this._entityVersionService = entityVersionImportService;
    }

    public void setSettings(Settings settings) {
        this._settings = settings;
    }

    public void setI18nService(I18nService i18nService) {
        this._i18nService = i18nService;
    }

    public void setEntityVersionAuthor(long entityVersionAuthor) {
        this._entityVersionAuthor = new PersonId(entityVersionAuthor);
    }

    public void setReviewers(@Nullable List<Long> reviewers) {
        if (reviewers != null) {
            this._reviewers = (ImmutableList)reviewers.stream().filter(Objects::nonNull).map(PersonId::new).collect(ImmutableList.toImmutableList());
        }
    }

    public void setDefaultAdminId(long adminId) {
        this._defaultAdminId = new PersonId(adminId);
    }

    public void setLinkedEntities(List<Long> linkedEntitiesIds) {
        this._linkedEntitiesIds = (ImmutableSet)linkedEntitiesIds.stream().filter(Objects::nonNull).map(EntityId::new).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    @ManagedOperation
    public final ImportStatistics importEntities() throws ImportException {
        return this._importProcessLockService.acquireAndExecute(() -> this.doImport());
    }

    @Nonnull
    protected abstract EntityImportDAO<T> getEntityImportDAO();

    @Override
    protected void initBeforeImport() {
        this._linkedEntities = this.getLinkedEntitiesList();
    }

    @Override
    protected void cleanUpAfterImport() {
    }

    @Override
    protected List<E> processBatch(List<? extends E> importModels, ImportStatistics statistics, ImportUpdateEventCollector eventCollector) {
        PersonId defaultAdmin = this.getValidatedDefaultAdmin();
        EntityImportReviewHelper helper = this.initReviewTriggerHelper(this._type);
        ArrayList<EntityImportModel> toPostProcess = new ArrayList<EntityImportModel>();
        for (EntityImportModel importResult : importModels) {
            try {
                EntityImportModel importedModel = this.processImportModel(importResult, defaultAdmin, helper, statistics, eventCollector);
                if (importedModel == null) continue;
                toPostProcess.add(importedModel);
            }
            catch (RuntimeException ex) {
                IMPORT_LOG.error("Import of " + importResult.getExternalId() + " failed", (Throwable)ex);
                statistics.incFailed();
            }
        }
        return toPostProcess;
    }

    @Nonnull
    private EntityImportReviewHelper initReviewTriggerHelper(EntityType entityType) {
        EntityVersionConstants entityVersionConstants = this._i18nService.createProxy(EntityVersionConstants.class, this._settings.defaultLanguage());
        String changeMessage = entityVersionConstants.changeMessageByImport();
        String commentForReviewer = entityVersionConstants.commentForReviewerByImport();
        if (!this._entityConfigService.releaseProcessMandatory(entityType)) {
            IMPORT_LOG.info("Release process is not activated for imported type " + entityType + ".");
            return EntityImportReviewHelper.DISABLED;
        }
        if (this._entityVersionAuthor == null) {
            IMPORT_LOG.error("No version author provided. No releases process will be triggered.");
            return EntityImportReviewHelper.DISABLED;
        }
        DBPerson versionAuthor = this._personService.getPersonById(this._entityVersionAuthor);
        if (versionAuthor == null) {
            IMPORT_LOG.error("The provided version author (" + this._entityVersionAuthor + ") does not exist. No releases process will be triggered.");
            return EntityImportReviewHelper.DISABLED;
        }
        if (this._reviewers == null || this._reviewers.isEmpty()) {
            IMPORT_LOG.error("No reviewers provided. No releases process will be triggered.");
            return EntityImportReviewHelper.DISABLED;
        }
        return new EntityImportReviewHelperImpl(versionAuthor.getId(), this._reviewers, commentForReviewer, changeMessage, this._entityConfigService, new EntityImportReviewHelper.EntityVersionAccess(){

            @Override
            public EntityVersion getLastPublicVersionBefore(EntityVersionId versionId) {
                return AbstractEntityImportServiceImpl.this._entityVersionService.getLastPublicVersionBefore(versionId);
            }
        }, this._clock);
    }

    @CheckForNull
    private PersonId getValidatedDefaultAdmin() {
        if (this._defaultAdminId == null) {
            return null;
        }
        DBPerson defaultAdmin = this._personService.getPersonById(this._defaultAdminId);
        return defaultAdmin != null ? defaultAdmin.getId() : null;
    }

    @CheckForNull
    private E processImportModel(E importResult, @Nullable PersonId defaultAdminId, EntityImportReviewHelper helper, ImportStatistics statistics, ImportUpdateEventCollector eventCollector) {
        EntityImportBean importedEntity = ((EntityImportModel)importResult).getEntity();
        Object externalId = ((EntityImportModel)importResult).getExternalId();
        if (externalId == null) {
            return null;
        }
        try {
            if (this.checkValid((EntityImportModel<T>)importResult, defaultAdminId)) {
                DBEntity entity = this.createDBEntity(importedEntity);
                EntityId entityId = this.getEntityImportDAO().getInternalId(externalId);
                entity.setId(entityId);
                PersonId adminId = (PersonId)MoreObjects.firstNonNull((Object)((EntityImportModel)importResult).getAdminId(), (Object)defaultAdminId);
                if (entityId == null) {
                    importedEntity.setEntityId(this.insertDBEntity(entity, importedEntity, adminId));
                    statistics.incInserted();
                } else if (this.updateEntity(entity, entityId, externalId, adminId, helper, statistics)) {
                    importedEntity.setEntityId(entityId);
                } else {
                    return null;
                }
                eventCollector.add(new EntityUpdateEvent(importedEntity.getEntityId()));
                return importResult;
            }
            statistics.incFailed();
        }
        catch (ServiceException e) {
            IMPORT_LOG.error("Error occured while importing entity " + externalId, (Throwable)e);
            statistics.incFailed();
        }
        catch (DAOException e) {
            IMPORT_LOG.error("Error occured while importing entity " + externalId, (Throwable)e);
            statistics.incFailed();
        }
        return null;
    }

    private boolean checkValid(EntityImportModel<T> importResult, @Nullable PersonId defaultEntityAdmin) {
        String name = importResult.getEntity().getName();
        if (StringUtil.isBlank(name)) {
            IMPORT_LOG.warn("Can not import entity with empty name. Import of entity " + importResult.getExternalId() + " failed.");
            return false;
        }
        if (importResult.getAdminId() == null && defaultEntityAdmin == null) {
            IMPORT_LOG.info("There is no admin defined for entity with external id " + importResult.getExternalId() + ". Cannot create entity without admin. Import of entity " + name + " failed.");
            return false;
        }
        return true;
    }

    private boolean updateEntity(DBEntity entity, EntityId entityId, T externalId, PersonId admin, EntityImportReviewHelper helper, ImportStatistics statistics) {
        DBEntity toSave = this._entityService.getByIdNotNull(entityId);
        EntityType entityType = toSave.getType();
        EverythingAllowedAuthorizationCheckContextWithUserId auth = new EverythingAllowedAuthorizationCheckContextWithUserId(admin, this._tenantIdSupplier.get(), this._settings.defaultLanguage());
        if (entityType.equals(entity.getType())) {
            if (this.updateEntityIfNecessary(toSave, entity, auth, externalId)) {
                statistics.incUpdated();
            } else {
                statistics.incSkipped();
            }
            this.releaseNewEntityVersionIfNecessary(entityId, entityType, helper);
            return true;
        }
        IMPORT_LOG.warn("Import of entity (" + externalId + ") failed. Can't change entity type! In database: " + toSave.getType() + ", from import: " + entity.getType());
        statistics.incFailed();
        return false;
    }

    private boolean updateEntityIfNecessary(DBEntity current, DBEntity updated, AuthorizationCheckContextWithUserId auth, T externalId) {
        boolean wasEntityUpdated = this.wasEntityUpdated(current, updated);
        if (wasEntityUpdated) {
            current.setLinkedEntities(updated.getLinkedEntities());
            current.setName(updated.getName());
            this._entityService.updateEntity(auth, current);
            IMPORT_LOG.info("Updated entity ({}) with entityId {}", externalId, (Object)current.getId());
        }
        return wasEntityUpdated;
    }

    private boolean wasEntityUpdated(DBEntity current, DBEntity updated) {
        EntityId entityId = current.getId();
        return !entityId.equals(updated.getId()) || !Objects.equals(current.getName(), updated.getName());
    }

    private void releaseNewEntityVersionIfNecessary(EntityId entityId, EntityType entityType, EntityImportReviewHelper helper) {
        if (!helper.isReviewTriggerEnabled()) {
            return;
        }
        EverythingAllowedAuthorizationCheckContextWithUserId versionAuthorAuthCtx = new EverythingAllowedAuthorizationCheckContextWithUserId(helper.getEntityVersionAuthor(), this._tenantIdSupplier.get(), this._settings.defaultLanguage());
        EntityVersion version = this._entityVersionService.getCurrentEntityVersionForUser(entityId, versionAuthorAuthCtx);
        if (helper.isEntityArchived(version)) {
            EntityVersionReleaseClientModel releaseData = helper.createVersionReleaseModel(entityType, version);
            try {
                EntityVersion newVersion = this._entityVersionService.stageVersionForReview(releaseData, versionAuthorAuthCtx, false);
                IMPORT_LOG.info("Released new version (" + newVersion.getId() + ") for previously archived entity (" + entityId + ").");
            }
            catch (JucoConstraintViolationException e) {
                StringBuilder error = new StringBuilder("Releasing new version for entity (" + entityId + ") failed with error:\n");
                for (JucoConstraintViolation v : e.getConstraintViolations()) {
                    error.append(v.getPropertyPath() + ": " + v.getMessage() + "\n");
                }
                IMPORT_LOG.error(error.toString());
                throw e;
            }
        } else if (helper.isEntityInReview(version)) {
            IMPORT_LOG.info("Not releasing a new version for entity (" + entityId + ") because a review is already in progress.");
        }
    }

    @Nonnull
    private DBEntity createDBEntity(EntityImportBean<T> importedEntity) {
        DBEntity entity = new DBEntity();
        entity.setName(importedEntity.getName().trim());
        entity.setStartAt(importedEntity.getStartAt());
        entity.setEndAt(importedEntity.getEndAt());
        entity.setTimeZone(importedEntity.getTimeZone());
        entity.setLocation(importedEntity.getLocation());
        entity.setType(this._type);
        entity.setLinkedEntities((List<DBEntityLink>)this._linkedEntities);
        return entity;
    }

    @Nonnull
    private EntityId insertDBEntity(DBEntity entity, EntityImportBean<T> importedEntity, PersonId admin) {
        this._entityService.createEntity(entity, null, null, (ImmutableList<DynamicAttributeEditModel>)ImmutableList.of(), new EverythingAllowedAuthorizationCheckContextWithUserId(admin, this._tenantIdSupplier.get(), this._settings.defaultLanguage()), false);
        EntityId entityId = entity.getId();
        this.getEntityImportDAO().insertIdMapping(entityId, importedEntity.getExternalId());
        if (IMPORT_LOG.isInfoEnabled()) {
            IMPORT_LOG.info("Imported new entity (" + importedEntity.getExternalId() + ") with entityId " + entityId);
        }
        return entityId;
    }

    @Nonnull
    private ImmutableList<DBEntityLink> getLinkedEntitiesList() {
        Map<EntityId, DBEntity> existingEntities = this._entityService.getByIds((Set<EntityId>)this._linkedEntitiesIds);
        Function<EntityId, DBEntityLink> toEntityLink = input -> {
            if (input == null) {
                IMPORT_LOG.warn("Could not create DBEntityLink for entity with id null.");
                return null;
            }
            if (existingEntities.get(input) == null) {
                IMPORT_LOG.warn("Could not create DBEntityLink since entity with id " + input + " does not exist.");
                return null;
            }
            return new DBEntityLink((EntityId)input, false, false);
        };
        return (ImmutableList)this._linkedEntitiesIds.stream().map(toEntityLink).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
    }

    @PostConstruct
    public void postConstruct() {
        if (!this._entityConfigService.entityTypeDefined(this._type)) {
            throw new IllegalArgumentException("Type " + this._type + " configured for entity import is not a valid entity type configured for this platform.");
        }
    }
}

