/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business;

import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.business.model.EntityVersion;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.EntityVersionId;
import de.justsoftware.onx.container.shared.model.EntityVersionReleaseClientModel;
import de.justsoftware.onx.migration.business.EntityImportService;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface EntityImportReviewHelper {
    public static final EntityImportReviewHelper DISABLED = new EntityImportReviewHelper(){

        @Override
        public boolean isReviewTriggerEnabled() {
            return false;
        }

        @Override
        public EntityVersionReleaseClientModel createVersionReleaseModel(EntityType entityType, EntityVersion version) {
            return this.failWithError("entity version review unsupported");
        }

        @Nonnull
        private EntityVersionReleaseClientModel failWithError(@Nonnull String message) {
            EntityImportService.IMPORT_LOG.error(message);
            throw new UnsupportedOperationException(message);
        }

        @Override
        public boolean isEntityArchived(EntityVersion entityVersion) {
            return false;
        }

        @Override
        public boolean isEntityInReview(EntityVersion entityVersion) {
            return false;
        }

        @Override
        public PersonId getEntityVersionAuthor() {
            String errrorMessage = "getEntityVersionAuthor called for DISABLED EntityImportReviewHelper";
            EntityImportService.IMPORT_LOG.error("getEntityVersionAuthor called for DISABLED EntityImportReviewHelper");
            throw new UnsupportedOperationException("getEntityVersionAuthor called for DISABLED EntityImportReviewHelper");
        }
    };

    public boolean isReviewTriggerEnabled();

    @Nonnull
    public EntityVersionReleaseClientModel createVersionReleaseModel(EntityType var1, EntityVersion var2);

    public boolean isEntityArchived(@Nullable EntityVersion var1);

    public boolean isEntityInReview(@Nullable EntityVersion var1);

    @Nonnull
    public PersonId getEntityVersionAuthor();

    public static interface EntityVersionAccess {
        @CheckForNull
        public EntityVersion getLastPublicVersionBefore(@Nonnull EntityVersionId var1);
    }
}

