/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.mail.business.model;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.shared.server.util.DateUtil;
import com.google.common.base.MoreObjects;
import de.justsoftware.onx.common.shared.model.TimeZone;
import de.justsoftware.onx.mail.business.model.MailReceiver;
import de.justsoftware.onx.mail.business.model.MailReceiverImpl;
import de.justsoftware.onx.person.model.DBPerson;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTimeZone;

public final class MailReceivers {
    private MailReceivers() {
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static MailReceiver forPerson(DBPerson person, Settings settings) {
        return MailReceivers.createMailReceiver(person.getEmail(), (TimeZone)((Object)MoreObjects.firstNonNull((Object)((Object)person.getTimeZone()), (Object)((Object)settings.getDefaultTimeZone()))), (String)MoreObjects.firstNonNull((Object)person.getLanguageId(), (Object)settings.defaultLanguage()));
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static MailReceiver forEmail(String emailAddress, String locale, Settings settings) {
        return MailReceivers.createMailReceiver(emailAddress, settings.getDefaultTimeZone(), locale);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static MailReceiver forEmail(String emailAddress, Settings settings) {
        return MailReceivers.createMailReceiver(emailAddress, settings.getDefaultTimeZone(), settings.defaultLanguage());
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static MailReceiver createMailReceiver(String emailAddress, TimeZone timeZone, String languageId) {
        DateTimeZone dateTimeZone = DateUtil.toDateTimeZone(timeZone);
        Locale locale = new Locale(languageId);
        return new MailReceiverImpl(locale, dateTimeZone, emailAddress);
    }
}

