/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.mail.business.model;

import com.google.common.annotations.VisibleForTesting;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.mail.business.model.EntityMailModel;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EntityMailModels {
    @Nonnull
    public static EntityMailModel createForDBEntity(@Nonnull DBEntity entity) {
        return new EntityMailModelImplementation(entity);
    }

    @Nonnull
    @VisibleForTesting
    public static EntityMailModel createForTest(@Nonnull EntityType type, @Nonnull String name, @Nonnull EntityId entityId) {
        return new EntityMailModelImplementation(name, entityId, type, null, null);
    }

    @Nonnull
    @VisibleForTesting
    public static EntityMailModel createWithExternalDomain(@Nonnull EntityType type, @Nonnull String name, @Nonnull EntityId entityId, @Nonnull String external) {
        return new EntityMailModelImplementation(name, entityId, type, external, null);
    }

    @Nonnull
    @VisibleForTesting
    public static EntityMailModel createWithSubdomain(@Nonnull EntityType type, @Nonnull String name, @Nonnull EntityId entityId, @Nonnull String subdomain) {
        return new EntityMailModelImplementation(name, entityId, type, null, subdomain);
    }

    private static final class EntityMailModelImplementation
    implements EntityMailModel {
        private final String _name;
        private final EntityId _entityId;
        private final EntityType _type;

        private EntityMailModelImplementation(@Nonnull String name, @Nonnull EntityId entityId, @Nonnull EntityType type, @Nullable String externalDomain, @Nullable String subdomain) {
            this._name = name;
            this._entityId = entityId;
            this._type = type;
        }

        public EntityMailModelImplementation(@Nonnull DBEntity entity) {
            this._name = entity.getName();
            this._entityId = entity.getId();
            this._type = entity.getType();
        }

        @Override
        public EntityType getType() {
            return this._type;
        }

        @Override
        public EntityId getId() {
            return this._entityId;
        }

        @Override
        public String getName() {
            return this._name;
        }
    }
}

