/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.mail.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.shared.i18n.BasicConstants;
import com.freiheit.toro.common.shared.i18n.BasicMessages;
import com.freiheit.toro.common.shared.util.UrlUtil;
import com.google.common.base.Charsets;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.business.ServerUrlUtil;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.mail.business.EMailTemplate;
import de.justsoftware.onx.mail.business.GlobalMailTemplateKeys;
import de.justsoftware.onx.mail.business.MailHtmlMessageBean;
import de.justsoftware.onx.mail.business.MailMessageBean;
import de.justsoftware.onx.mail.business.MailTemplateContext;
import de.justsoftware.onx.mail.business.MailTemplateKey;
import de.justsoftware.onx.mail.business.MailTemplateManager;
import de.justsoftware.onx.mail.business.MultipartEMailTemplate;
import de.justsoftware.onx.mail.business.SendMailException;
import de.justsoftware.onx.mail.business.impl.VelocityResourceManager;
import de.justsoftware.onx.mail.business.impl.VelocityTemplateManagerConfigurator;
import java.io.StringWriter;
import java.io.Writer;
import java.security.SecureRandom;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="entityMailTemplateManager")
public class VelocityMailTemplateManagerImpl
implements MailTemplateManager,
VelocityTemplateManagerConfigurator {
    private static final Logger LOG = LoggerFactory.getLogger(VelocityMailTemplateManagerImpl.class);
    private static final String ENCODING = "utf8";
    private VelocityEngine _velocityEngine;
    @Autowired
    private Settings _settings;
    @Autowired
    private I18nService _i18nService;
    @Autowired
    private VelocityResourceManager _resourceManager;
    @Autowired
    private ServerUrlUtil _serverUrlUtil;
    @Autowired
    private EntityConfigService _entityConfig;

    @Autowired
    @ParametersAreNonnullByDefault
    public VelocityMailTemplateManagerImpl(VelocityResourceManager resourceManager) {
        this.setResourceManager(resourceManager);
    }

    @Nonnull
    private static VelocityEngine createVelocityEngine(VelocityResourceManager resourceManager) {
        VelocityEngine velocityEngine = new VelocityEngine();
        velocityEngine.setProperty("runtime.log", (Object)VelocityMailTemplateManagerImpl.makeUniqueVelocityLogName());
        velocityEngine.setProperty("input.encoding", (Object)ENCODING);
        velocityEngine.setProperty("output.encoding", (Object)ENCODING);
        resourceManager.updateResourceProperties(velocityEngine);
        try {
            velocityEngine.init();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return velocityEngine;
    }

    @Nonnull
    private static String makeUniqueVelocityLogName() {
        return "/tmp/velocity_" + Long.toHexString(System.currentTimeMillis()) + "_" + Long.toHexString(new SecureRandom().nextLong()) + ".log";
    }

    @Override
    public VelocityResourceManager getResourceManager() {
        return this._resourceManager;
    }

    @Override
    public void setResourceManager(VelocityResourceManager resourceManager) {
        this._velocityEngine = VelocityMailTemplateManagerImpl.createVelocityEngine(resourceManager);
        this._resourceManager = resourceManager;
    }

    private void insertI18N(@Nonnull MailTemplateContext context, @Nullable String locale) {
        context.put(GlobalMailTemplateKeys.BASIC_CONSTANTS, (Object)this._i18nService.createProxy(BasicConstants.class, locale));
        context.put(GlobalMailTemplateKeys.BASIC_MESSAGES, (Object)this._i18nService.createProxy(BasicMessages.class, locale));
        context.put(GlobalMailTemplateKeys.SETTINGS, (Object)this._settings);
        Object entObj = context.get(GlobalMailTemplateKeys.ENTITY);
        if (entObj instanceof DBEntity) {
            DBEntity entity = (DBEntity)entObj;
            String entityUrl = UrlUtil.getEntityOverviewUrl(entity, this._serverUrlUtil.getHtmlClientBaseUrl());
            context.put(GlobalMailTemplateKeys.ENTITY_URI, (Object)entityUrl);
        }
        this.setStartPageUrl(context, locale);
        this.setDomainUrl(context);
    }

    private void setStartPageUrl(@Nonnull MailTemplateContext context, @Nullable String locale) {
        Object baseUrl;
        String protocol = this._serverUrlUtil.getSystemProtocol() + "://";
        if (context.get(GlobalMailTemplateKeys.STARTPAGE_URI) == null && (baseUrl = this._serverUrlUtil.getHtmlClientBaseUrl()) != null) {
            if (!UrlUtil.hasProtocol((String)baseUrl)) {
                baseUrl = protocol + (String)baseUrl;
            }
            if (locale != null) {
                baseUrl = (String)baseUrl + "?locale=" + locale;
            }
            String startUrl = (String)baseUrl + "#start";
            context.put(GlobalMailTemplateKeys.STARTPAGE_URI, (Object)startUrl);
        }
    }

    private void setDomainUrl(@Nonnull MailTemplateContext context) {
        if (context.get(GlobalMailTemplateKeys.DOMAIN_URI) == null) {
            String protocol = this._serverUrlUtil.getSystemProtocol() + "://";
            Object domain = this._serverUrlUtil.getSystemDomain();
            if (domain != null) {
                if (!((String)domain).startsWith(protocol)) {
                    domain = protocol + (String)domain;
                }
                context.put(GlobalMailTemplateKeys.DOMAIN_URI, domain);
            }
        }
    }

    @Nonnull
    private VelocityContext buildContext(@Nonnull MailTemplateContext context, @Nullable String locale) {
        this.insertI18N(context, locale);
        VelocityContext ctxt = new VelocityContext();
        for (Map.Entry entry : context.entrySet()) {
            ctxt.put(((MailTemplateKey)entry.getKey()).toString(), entry.getValue());
        }
        return ctxt;
    }

    private void updateContext(@Nonnull VelocityContext ctxt, @Nonnull MailTemplateContext context) {
        for (Map.Entry entry : context.entrySet()) {
            ctxt.put(((MailTemplateKey)entry.getKey()).toString(), entry.getValue());
        }
    }

    @Override
    public MailMessageBean getMail(EMailTemplate template, String recipientAddress, String locale) throws SendMailException {
        if (LOG.isDebugEnabled()) {
            LOG.info("merging mailtemplate...\n  type: " + template.getType() + ", language-ID: " + locale + " and context:\n  " + template.getContext().toString());
        }
        VelocityContext context = this.buildContext(template.getContext(), locale);
        String subject = this.getSubject(context, template, locale);
        String text = this.getText(context, template, locale);
        return new MailMessageBean(subject, text, recipientAddress, template.getType());
    }

    @Override
    public MailHtmlMessageBean getHtmlMail(MultipartEMailTemplate template, String recipientAddress, String locale) throws SendMailException {
        if (LOG.isDebugEnabled()) {
            LOG.info("merging mailtemplate...\n  type: " + template.getHtmlType() + ", language-ID: " + locale + " and context:\n  " + template.getContext().toString());
        }
        VelocityContext context = this.buildContext(template.getContext(), locale);
        String subject = this.getSubject(context, template, locale);
        String text = this.getText(context, template, locale);
        this.updateContext(context, template.getHtmlContext());
        String html = this.getHtml(context, template, locale);
        return new MailHtmlMessageBean(subject, text, html, recipientAddress, template.getType());
    }

    @Nonnull
    private String getText(@Nonnull VelocityContext context, @Nonnull EMailTemplate template, @Nullable String locale) throws SendMailException {
        return this.getText(context, this._resourceManager.getResourceName(template.getType(), template.getEntityType(), locale));
    }

    @Nonnull
    private String getSubject(@Nonnull VelocityContext context, @Nonnull EMailTemplate template, @Nullable String locale) throws SendMailException {
        switch (template.getSubjectType()) {
            case STATIC: {
                String subject = template.getSubject();
                if (subject == null) {
                    LOG.error("illegal combination of static mail-subject-type and no subject!:" + template.getType());
                    return "";
                }
                return this.getText(context, this._resourceManager.getResourceName(subject));
            }
        }
        return this.getText(context, this._resourceManager.getResourceName(template.getSubjectType(), template.getEntityType(), locale));
    }

    @Nonnull
    private String getHtml(@Nonnull VelocityContext context, @Nonnull MultipartEMailTemplate template, @Nullable String locale) throws SendMailException {
        return this.getText(context, this._resourceManager.getResourceName(template.getHtmlType(), template.getEntityType(), locale));
    }

    @Nonnull
    private String getText(@Nonnull VelocityContext context, @Nonnull String resourceName) throws SendMailException {
        StringWriter writer = new StringWriter();
        try {
            if (this._velocityEngine.mergeTemplate(resourceName, Charsets.UTF_8.name(), (Context)context, (Writer)writer)) {
                return writer.toString();
            }
            throw new SendMailException("Can't merge template " + resourceName);
        }
        catch (SendMailException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SendMailException(e);
        }
    }
}

