/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.mail.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.shared.server.util.StringUtil;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.notificationclient.model.NotificationMail;
import de.justsoftware.notificationclient.model.NotificationMailItem;
import de.justsoftware.onx.appswitcher.business.AppConfigService;
import de.justsoftware.onx.appswitcher.model.AppConfig;
import de.justsoftware.onx.appswitcher.shared.model.CoreApp;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.business.InternalLinkService;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.mail.business.MailModelService;
import de.justsoftware.onx.mail.business.MailService;
import de.justsoftware.onx.mail.business.NotificationMailService;
import de.justsoftware.onx.mail.business.model.FooterMailModel;
import de.justsoftware.onx.mail.business.model.HeaderMailModel;
import de.justsoftware.onx.mail.business.model.MailReceiver;
import de.justsoftware.onx.mail.business.model.MailReceivers;
import de.justsoftware.onx.mail.business.model.NotificationListMailModel;
import de.justsoftware.onx.mail.business.model.ThemeMailModel;
import de.justsoftware.onx.notifications.shared.i18n.NotificationCenterMessages;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.person.shared.model.EmailNotificationSettingsBean;
import de.justsoftware.onx.tenant.business.PersonTenantService;
import de.justsoftware.onx.tenantdesign.ThemeService;
import de.justsoftware.onx.tenantdesign.model.Theme;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class NotificationMailServiceImpl
implements NotificationMailService {
    private static final String DEFAULT_APP_COLOR = "#CACBCC";
    private final ThemeService _themeService;
    private final MailService _mailService;
    private final MailModelService _mailModelService;
    private final Settings _settings;
    private final I18nService _i18nService;
    private final InternalLinkService _internalLinkService;
    private final PersonService _personService;
    private final PersonTenantService _tenantService;
    private final AppConfigService _appConfigService;

    @Autowired
    public NotificationMailServiceImpl(ThemeService themeService, MailService mailService, MailModelService mailModelService, Settings settings, I18nService i18nService, InternalLinkService internalLinkService, PersonService personService, PersonTenantService tenantService, AppConfigService appConfigService) {
        this._themeService = themeService;
        this._mailService = mailService;
        this._mailModelService = mailModelService;
        this._settings = settings;
        this._i18nService = i18nService;
        this._internalLinkService = internalLinkService;
        this._personService = personService;
        this._tenantService = tenantService;
        this._appConfigService = appConfigService;
    }

    @Override
    public void sendNotificationEmail(NotificationMail notificationMail, DBPerson receiver) {
        if (receiver.isBlocked() || !receiver.isActive() || notificationMail.getNotifications().isEmpty() || !this.hasNotificationMailsEnabled(receiver.getId())) {
            return;
        }
        Optional tenantOptional = this._tenantService.getTenantIdsForPerson(receiver.getId()).stream().findFirst();
        if (tenantOptional.isEmpty()) {
            return;
        }
        TenantId tenant = (TenantId)tenantOptional.get();
        MailReceiver mailReceiver = MailReceivers.forPerson(receiver, this._settings);
        Locale locale = mailReceiver.getLocale();
        NotificationCenterMessages notificationCenterMessages = this._i18nService.createProxy(NotificationCenterMessages.class, locale.getLanguage());
        String subject = notificationCenterMessages.notificationMailSubject(this._settings.getDefaultSiteTitle());
        String headline = notificationMail.getNotifications().size() > 1 ? notificationCenterMessages.notificationMailHeadlineMultipleNotifications() : notificationCenterMessages.notificationMailHeadlineSingleNotifications();
        String buttonText = notificationCenterMessages.notificationMailButtonText();
        String buttonUrl = this._internalLinkService.makeURL("#/homescreen?notification");
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT).withLocale(locale).withZone(ZoneId.systemDefault());
        Theme tenantTheme = this._themeService.getTheme(tenant);
        Map appColors = tenantTheme.getAppColors().entrySet().stream().collect(HashMap::new, (m, e) -> m.put(((CoreApp)((Object)((Object)e.getKey()))).getSimpleName(), (String)e.getValue()), HashMap::putAll);
        Map<String, String> appNameMap = this._appConfigService.getAllAppConfigs().stream().collect(Collectors.toMap(appConfig -> appConfig.getAppId().getId(), AppConfig::getName));
        ImmutableList notificationMailModels = (ImmutableList)notificationMail.getNotifications().stream().map(mailItem -> {
            String appId = mailItem.getAppId();
            String appColor = appColors.getOrDefault(appId, DEFAULT_APP_COLOR);
            String appName = appNameMap.getOrDefault(appId, notificationCenterMessages.notificationMailUnknownAppName());
            String timestamp = dateTimeFormatter.format(mailItem.getTimestamp());
            String localizedTitle = (String)mailItem.getLocalizedTitle().get((Object)locale);
            String title = !Strings.isNullOrEmpty((String)localizedTitle) ? localizedTitle : mailItem.getDefaultTitle();
            String text = this.getText((NotificationMailItem)mailItem, locale);
            String authorName = mailItem.getMailAuthorName();
            String containerName = this.getLocalizedString(locale, mailItem.getDefaultMailContainerName(), (ImmutableMap<Locale, String>)mailItem.getLocalizedMailContainerName());
            String secondaryText = this.getLocalizedString(locale, mailItem.getDefaultSecondaryText(), (ImmutableMap<Locale, String>)mailItem.getLocalizedSecondaryText());
            return new NotificationMailModelImpl(appId, appName, appColor, timestamp, StringUtil.foldText(title, 40), authorName, containerName, StringUtil.foldText(text, 300), secondaryText);
        }).collect(ImmutableList.toImmutableList());
        this._mailService.sendEmail(new NotificationListMailModelImpl(headline, subject, notificationMail.getAdditionalNotificationCount(), buttonText, buttonUrl, (ImmutableList<NotificationListMailModel.NotificationMailModel>)notificationMailModels, mailReceiver));
    }

    @CheckForNull
    private String getLocalizedString(Locale locale, @Nullable String defaultString, @Nullable ImmutableMap<Locale, String> localizedMap) {
        if (localizedMap != null) {
            String localizedString = (String)localizedMap.get((Object)locale);
            return !Strings.isNullOrEmpty((String)localizedString) ? localizedString : defaultString;
        }
        return defaultString;
    }

    private String getText(NotificationMailItem mailItem, Locale locale) {
        String text = mailItem.getDefaultMailReplacementText() != null ? this.getLocalizedString(locale, mailItem.getDefaultMailReplacementText(), (ImmutableMap<Locale, String>)mailItem.getLocalizedMailReplacementText()) : this.getLocalizedString(locale, mailItem.getDefaultText(), (ImmutableMap<Locale, String>)mailItem.getLocalizedText());
        assert (text != null);
        return text;
    }

    private boolean hasNotificationMailsEnabled(PersonId personId) {
        EmailNotificationSettingsBean settings = this._personService.getEmailNotificationSettingsByPersonIds((Set<PersonId>)ImmutableSet.of((Object)personId)).getOrDefault(personId, null);
        if (settings == null) {
            return true;
        }
        return settings.isEmailNotificationConcernMe();
    }

    @ParametersAreNonnullByDefault
    private final class NotificationListMailModelImpl
    implements NotificationListMailModel {
        private final String _headline;
        private final String _subject;
        private final int _additionalNotificationCount;
        private final String _buttonText;
        private final String _buttonUrl;
        private final ImmutableList<NotificationListMailModel.NotificationMailModel> _notificationMailModels;
        private final MailReceiver _receiver;
        private final HeaderMailModel _headerModel;
        private final FooterMailModel _footerModel;
        private final ThemeMailModel _themeModel;

        private NotificationListMailModelImpl(String headline, String subject, int additionalNotificationCount, String buttonText, String buttonUrl, ImmutableList<NotificationListMailModel.NotificationMailModel> notificationMailModels, MailReceiver receiver) {
            this._headerModel = NotificationMailServiceImpl.this._mailModelService.getHeaderMailModel();
            this._footerModel = NotificationMailServiceImpl.this._mailModelService.getFooterMailModel();
            this._themeModel = NotificationMailServiceImpl.this._mailModelService.getThemeMailModel();
            this._headline = headline;
            this._subject = subject;
            this._additionalNotificationCount = additionalNotificationCount;
            this._buttonText = buttonText;
            this._buttonUrl = buttonUrl;
            this._notificationMailModels = notificationMailModels;
            this._receiver = receiver;
        }

        @Override
        public String getHeadline() {
            return this._headline;
        }

        @Override
        public String getSubject() {
            return this._subject;
        }

        @Override
        public MailReceiver getReceiver() {
            return this._receiver;
        }

        @Override
        public HeaderMailModel getHeader() {
            return this._headerModel;
        }

        @Override
        public FooterMailModel getFooter() {
            return this._footerModel;
        }

        @Override
        public ThemeMailModel getTheme() {
            return this._themeModel;
        }

        @Override
        public int getAdditionalNotificationCount() {
            return this._additionalNotificationCount;
        }

        @Override
        public String getButtonText() {
            return this._buttonText;
        }

        @Override
        public String getButtonUrl() {
            return this._buttonUrl;
        }

        @Override
        public ImmutableList<NotificationListMailModel.NotificationMailModel> getNotificationMailModels() {
            return this._notificationMailModels;
        }
    }

    @ParametersAreNonnullByDefault
    private static final class NotificationMailModelImpl
    implements NotificationListMailModel.NotificationMailModel {
        private final String _appId;
        private final String _appBackgroundColor;
        private final String _appName;
        private final String _timestamp;
        private final String _title;
        private final String _containerName;
        private final String _authorName;
        private final String _text;
        private final String _secondaryText;

        public NotificationMailModelImpl(String appId, String appName, String appBackgroundColor, String timestamp, String title, @Nullable String authorName, @Nullable String containerName, String text, @Nullable String secondaryText) {
            this._appId = appId;
            this._appBackgroundColor = appBackgroundColor;
            this._appName = appName;
            this._timestamp = timestamp;
            this._title = title;
            this._authorName = authorName;
            this._containerName = containerName;
            this._text = text;
            this._secondaryText = secondaryText;
        }

        @Override
        @Nonnull
        public String getAppId() {
            return this._appId;
        }

        @Override
        @Nonnull
        public String getAppIconPath() {
            return "images/emailAppLogos/" + this._appId + ".png";
        }

        @Override
        @Nonnull
        public String getAppBackgroundColor() {
            return this._appBackgroundColor;
        }

        @Override
        @Nonnull
        public String getAppName() {
            return this._appName;
        }

        @Override
        @Nonnull
        public String getTimestamp() {
            return this._timestamp;
        }

        @Override
        @Nonnull
        public String getTitle() {
            return this._title;
        }

        @Override
        @CheckForNull
        public String getContainerName() {
            return this._containerName;
        }

        @Override
        @CheckForNull
        public String getAuthorName() {
            return this._authorName;
        }

        @Override
        @Nonnull
        public String getText() {
            return this._text;
        }

        @Override
        @CheckForNull
        public String getSecondaryText() {
            if (!Strings.isNullOrEmpty((String)this._secondaryText)) {
                return this._secondaryText;
            }
            return null;
        }
    }
}

