/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.mail.business.impl;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import de.justsoftware.onx.mail.business.EMailTemplate;
import de.justsoftware.onx.mail.business.MailManager;
import de.justsoftware.onx.mail.business.MailType;
import de.justsoftware.onx.mail.business.SendMailException;
import de.justsoftware.onx.person.model.DBPerson;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nonnull;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="mailManager")
public class MailQueue
implements MailManager {
    private static final Logger LOG = LoggerFactory.getLogger(MailQueue.class);
    private final MailManager _mailManager;
    private final ExecutorService _executorService = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("MailQueue-%d").build());

    @Autowired
    public MailQueue(@Nonnull @Qualifier(value="applicationMailManager") MailManager mailManager) {
        this._mailManager = mailManager;
    }

    @PreDestroy
    public void shutdown() {
        this._executorService.shutdown();
        LOG.info("MailSender is told to stop");
    }

    @Override
    public void sendMail(final EMailTemplate email) throws SendMailException {
        this._executorService.execute(new MailQueueRunnable(){

            @Override
            protected void send() throws SendMailException {
                MailQueue.this._mailManager.sendMail(email);
            }
        });
    }

    @Override
    public void sendMail(final DBPerson recipient, final String subject, final String text, final MailType type) {
        this._executorService.execute(new MailQueueRunnable(){

            @Override
            protected void send() throws SendMailException {
                MailQueue.this._mailManager.sendMail(recipient, subject, text, type);
            }
        });
    }

    private abstract class MailQueueRunnable
    implements Runnable {
        private MailQueueRunnable() {
        }

        @Override
        public final void run() {
            try {
                this.send();
            }
            catch (SendMailException | RuntimeException e) {
                LOG.error("Exception while sending email: ", (Throwable)e);
            }
        }

        protected abstract void send() throws SendMailException;
    }
}

