/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.mail.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.business.ServerLocalizedMessages;
import de.justsoftware.onx.common.business.impl.ServerDateFormatter;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.mail.business.ImportResultMailService;
import de.justsoftware.onx.mail.business.MailModelService;
import de.justsoftware.onx.mail.business.MailService;
import de.justsoftware.onx.mail.business.model.FooterMailModel;
import de.justsoftware.onx.mail.business.model.HeaderMailModel;
import de.justsoftware.onx.mail.business.model.ImportFailedMailModel;
import de.justsoftware.onx.mail.business.model.ImportResultMailModel;
import de.justsoftware.onx.mail.business.model.MailReceiver;
import de.justsoftware.onx.mail.business.model.MailReceivers;
import de.justsoftware.onx.mail.business.model.ThemeMailModel;
import de.justsoftware.onx.migration.business.model.ImportStatistics;
import de.justsoftware.onx.migration.shared.i18n.ImportMessages;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.toolbox.clock.Clock;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class ImportResultMailServiceImpl
implements ImportResultMailService {
    @Autowired
    MailService _mailService;
    @Autowired
    PersonService _personService;
    @Autowired
    MailModelService _mailModelService;
    @Autowired
    Settings _settings;
    @Autowired
    I18nService _i18nService;
    @Autowired
    Clock _clock;

    @Override
    public void notifyImportFailed(String error) {
        String email = this._settings.getFailedImportResultRecipient();
        if (StringUtil.isBlank(email)) {
            return;
        }
        MailReceiver receiver = MailReceivers.forEmail(email, this._settings);
        ServerLocalizedMessages lm = this._i18nService.getLocalizedMessages(receiver.getLocale().getLanguage());
        ServerDateFormatter formatter = new ServerDateFormatter(lm, receiver.getTimeZone());
        String subject = lm.importMessages().importFailed();
        ImportFailedMailModelImpl mailModel = new ImportFailedMailModelImpl(subject, receiver, error, formatter.formatDateTime(this._clock.now().toDate()));
        this._mailService.sendEmail(mailModel);
    }

    @Override
    public void sendImportResult(PersonId recipientId, ImportStatistics importStatistics) {
        DBPerson recipient = this._personService.getPersonByIdNotNull(recipientId);
        MailReceiver receiver = MailReceivers.forPerson(recipient, this._settings);
        ServerLocalizedMessages lm = this._i18nService.getLocalizedMessages(receiver.getLocale().getLanguage());
        ImportResultMailModel mailModel = this.createMailModel(lm, importStatistics, receiver);
        this._mailService.sendEmail(mailModel);
    }

    @Nonnull
    private ImportResultMailModel createMailModel(ServerLocalizedMessages localizedMessages, ImportStatistics importStatistics, MailReceiver receiver) {
        ServerDateFormatter formatter = new ServerDateFormatter(localizedMessages, receiver.getTimeZone());
        String subject = localizedMessages.importMessages().importFinished();
        DateTime startDate = importStatistics.getStartTime();
        DateTime endDate = (DateTime)MoreObjects.firstNonNull((Object)importStatistics.getEndTime(), (Object)this._clock.now());
        long duration = endDate.getMillis() - startDate.getMillis();
        ImmutableMap errors = importStatistics.getErrors().asMap();
        ImmutableMap.Builder errorMessages = ImmutableMap.builder();
        for (Map.Entry entry : errors.entrySet()) {
            String message = this.translateImportErrorType((ImportStatistics.ImportErrorType)((Object)entry.getKey()), localizedMessages);
            errorMessages.put((Object)message, (Object)((Collection)entry.getValue()));
        }
        return new ImportResultMailModelImpl(subject, formatter.formatDateTime(startDate.toDate()), formatter.formatDateTime(endDate.toDate()), duration, importStatistics.getProcessedCount(), importStatistics.getInsertCount(), importStatistics.getUpdateCount(), importStatistics.getSkippedCount(), importStatistics.getFailedCount(), receiver, (Map<String, Collection<String>>)errorMessages.build(), importStatistics.getSuccessfulImports(), importStatistics.getFailedImports());
    }

    private String translateImportErrorType(ImportStatistics.ImportErrorType type, ServerLocalizedMessages translations) {
        ImportMessages importMessages = translations.importMessages();
        switch (type) {
            case DELETED_IN_JUST: {
                return importMessages.importErrorDeletedInJust();
            }
            case EXCEPTION: {
                return importMessages.importErrorException();
            }
            case INVALID_INTERNAL_ID: {
                return importMessages.importErrorInvalidInternalId();
            }
            case MISSING_EMAIL: {
                return importMessages.importErrorMissingEmail();
            }
            case MISSING_EXTERNAL_ID: {
                return importMessages.importErrorMissingExternalId();
            }
            case MISSING_FIRSTNAME: {
                return importMessages.importErrorMissingFirstname();
            }
            case MISSING_LASTNAME: {
                return importMessages.importErrorMissingLastname();
            }
        }
        return null;
    }

    @ParametersAreNonnullByDefault
    private final class ImportResultMailModelImpl
    implements ImportResultMailModel {
        private final String _subject;
        private final MailReceiver _receiver;
        private final String _startDate;
        private final String _endDate;
        private final long _duration;
        private final int _processed;
        private final int _inserted;
        private final int _updated;
        private final int _skipped;
        private final int _failed;
        private final int _successfulImports;
        private final int _failedImports;
        private final Map<String, Collection<String>> _errors;
        private final HeaderMailModel _headerModel;
        private final FooterMailModel _footerModel;
        private final ThemeMailModel _themeModel;

        private ImportResultMailModelImpl(String subject, String startDate, String endDate, long duration, int processed, int inserted, int updated, int skipped, int failed, MailReceiver receiver, Map<String, Collection<String>> errors, int sucessfulImports, int failedImports) {
            this._headerModel = ImportResultMailServiceImpl.this._mailModelService.getHeaderMailModel();
            this._footerModel = ImportResultMailServiceImpl.this._mailModelService.getFooterMailModel();
            this._themeModel = ImportResultMailServiceImpl.this._mailModelService.getThemeMailModel();
            this._subject = subject;
            this._receiver = receiver;
            this._startDate = startDate;
            this._endDate = endDate;
            this._duration = duration;
            this._processed = processed;
            this._inserted = inserted;
            this._updated = updated;
            this._skipped = skipped;
            this._failed = failed;
            this._errors = errors;
            this._successfulImports = sucessfulImports;
            this._failedImports = failedImports;
        }

        @Override
        public String getSubject() {
            return this._subject;
        }

        @Override
        public MailReceiver getReceiver() {
            return this._receiver;
        }

        @Override
        public HeaderMailModel getHeader() {
            return this._headerModel;
        }

        @Override
        public FooterMailModel getFooter() {
            return this._footerModel;
        }

        @Override
        public ThemeMailModel getTheme() {
            return this._themeModel;
        }

        @Override
        public String getStartDate() {
            return this._startDate;
        }

        @Override
        public String getEndDate() {
            return this._endDate;
        }

        @Override
        public long getDuration() {
            return this._duration;
        }

        @Override
        public int getProcessed() {
            return this._processed;
        }

        @Override
        public int getInserted() {
            return this._inserted;
        }

        @Override
        public int getUpdated() {
            return this._updated;
        }

        @Override
        public int getSkipped() {
            return this._skipped;
        }

        @Override
        public int getFailed() {
            return this._failed;
        }

        @Override
        public Map<String, Collection<String>> getErrors() {
            return this._errors;
        }

        @Override
        public int getFailedImports() {
            return this._failedImports;
        }

        @Override
        public int getSuccessfulImports() {
            return this._successfulImports;
        }
    }

    @ParametersAreNonnullByDefault
    private final class ImportFailedMailModelImpl
    implements ImportFailedMailModel {
        private final String _subject;
        private final MailReceiver _receiver;
        private final String _error;
        private final String _endDate;
        private final HeaderMailModel _headerModel;
        private final FooterMailModel _footerModel;
        private final ThemeMailModel _themeModel;

        private ImportFailedMailModelImpl(String subject, MailReceiver receiver, String error, String endDate) {
            this._headerModel = ImportResultMailServiceImpl.this._mailModelService.getHeaderMailModel();
            this._footerModel = ImportResultMailServiceImpl.this._mailModelService.getFooterMailModel();
            this._themeModel = ImportResultMailServiceImpl.this._mailModelService.getThemeMailModel();
            this._subject = subject;
            this._receiver = receiver;
            this._error = error;
            this._endDate = endDate;
        }

        @Override
        public String getError() {
            return this._error;
        }

        @Override
        public String getEndDate() {
            return this._endDate;
        }

        @Override
        public String getSubject() {
            return this._subject;
        }

        @Override
        public MailReceiver getReceiver() {
            return this._receiver;
        }

        @Override
        public HeaderMailModel getHeader() {
            return this._headerModel;
        }

        @Override
        public FooterMailModel getFooter() {
            return this._footerModel;
        }

        @Override
        public ThemeMailModel getTheme() {
            return this._themeModel;
        }
    }
}

