/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.mail.business.impl;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import de.justsoftware.onx.common.business.events.ServerEventHandler;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.business.events.EntityMemberRemovedFromWaitinglistEvent;
import de.justsoftware.onx.container.shared.model.EntityMemberRole;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.mail.business.EntityNewParticipantFromWaitlistMailService;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.model.DBPerson;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy(value=false)
@ParametersAreNonnullByDefault
public class EventTriggeredMailDispatcherService
implements ServerEventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(EventTriggeredMailDispatcherService.class);
    private final EntityService _entityService;
    private final PersonService _personService;
    private final EntityNewParticipantFromWaitlistMailService _entityNewParticipantFromWaitlistMailService;

    @Autowired
    public EventTriggeredMailDispatcherService(EntityService entityService, PersonService personService, EntityNewParticipantFromWaitlistMailService entityNewParticipantFromWaitlistMailService) {
        this._entityService = entityService;
        this._personService = personService;
        this._entityNewParticipantFromWaitlistMailService = entityNewParticipantFromWaitlistMailService;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onEntityMemberRemovedFromWaitinglistEvent(EntityMemberRemovedFromWaitinglistEvent event) {
        if (!event.getNewMemberRoles().contains((Object)EntityMemberRole.EVENT_IS_ATTENDING)) {
            return;
        }
        DBEntity entity = this._entityService.getById(event.getEntityId());
        DBPerson participant = this._personService.getPersonById(event.getPersonId());
        if (entity != null && participant != null) {
            this._entityNewParticipantFromWaitlistMailService.sendNewParticipantFromWaitlistMail(entity, participant);
        }
    }
}

