/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.mail.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.mail.business.EntityNewParticipantFromWaitlistMailService;
import de.justsoftware.onx.mail.business.MailModelService;
import de.justsoftware.onx.mail.business.MailService;
import de.justsoftware.onx.mail.business.model.EntityMailModel;
import de.justsoftware.onx.mail.business.model.EntityMailModels;
import de.justsoftware.onx.mail.business.model.EntityNewParticipantFromWaitlistMailModel;
import de.justsoftware.onx.mail.business.model.FooterMailModel;
import de.justsoftware.onx.mail.business.model.HeaderMailModel;
import de.justsoftware.onx.mail.business.model.MailReceiver;
import de.justsoftware.onx.mail.business.model.MailReceivers;
import de.justsoftware.onx.mail.business.model.ThemeMailModel;
import de.justsoftware.onx.mail.i18n.EntityMails;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.model.DBPerson;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EntityNewParticipantFromWaitlistMailServiceImpl
implements EntityNewParticipantFromWaitlistMailService {
    private final PersonService _personService;
    private final Settings _settings;
    private final I18nService _i18nService;
    private final MailService _mailService;
    private final MailModelService _mailModelService;

    @Autowired
    @ParametersAreNonnullByDefault
    public EntityNewParticipantFromWaitlistMailServiceImpl(PersonService personService, Settings settings, I18nService i18nService, MailService mailService, MailModelService mailModelService) {
        this._personService = personService;
        this._settings = settings;
        this._i18nService = i18nService;
        this._mailService = mailService;
        this._mailModelService = mailModelService;
    }

    @Override
    public void sendNewParticipantFromWaitlistMail(DBEntity entity, DBPerson participant) {
        if (!participant.canLogin() || !this._personService.isEmailNotificationEnabled(participant.getId())) {
            return;
        }
        this._mailService.sendEmail(new EntityNewParticipantFromWaitlistMailModelImplementation(entity, participant));
    }

    private final class EntityNewParticipantFromWaitlistMailModelImplementation
    implements EntityNewParticipantFromWaitlistMailModel {
        private final MailReceiver _receiver;
        private final EntityMailModel _entity;
        private final String _subject;
        private final HeaderMailModel _header;
        private final FooterMailModel _footer;
        private final ThemeMailModel _theme;

        @ParametersAreNonnullByDefault
        private EntityNewParticipantFromWaitlistMailModelImplementation(DBEntity entity, DBPerson participant) {
            this._header = EntityNewParticipantFromWaitlistMailServiceImpl.this._mailModelService.getHeaderMailModel();
            this._footer = EntityNewParticipantFromWaitlistMailServiceImpl.this._mailModelService.getFooterMailModel();
            this._theme = EntityNewParticipantFromWaitlistMailServiceImpl.this._mailModelService.getThemeMailModel();
            this._receiver = MailReceivers.forPerson(participant, EntityNewParticipantFromWaitlistMailServiceImpl.this._settings);
            this._entity = EntityMailModels.createForDBEntity(entity);
            this._subject = EntityNewParticipantFromWaitlistMailServiceImpl.this._i18nService.createProxy(EntityMails.class, entity.getType(), this._receiver.getLocale().getLanguage()).entityNewParticipantFromWaitlistSubject(entity.getName());
        }

        @Override
        public String getSubject() {
            return this._subject;
        }

        @Override
        public MailReceiver getReceiver() {
            return this._receiver;
        }

        @Override
        public EntityMailModel getEntity() {
            return this._entity;
        }

        @Override
        public HeaderMailModel getHeader() {
            return this._header;
        }

        @Override
        public FooterMailModel getFooter() {
            return this._footer;
        }

        @Override
        public ThemeMailModel getTheme() {
            return this._theme;
        }
    }
}

