/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.mail.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.mail.business.EntityJoinRequestAcceptedMailService;
import de.justsoftware.onx.mail.business.MailModelService;
import de.justsoftware.onx.mail.business.MailService;
import de.justsoftware.onx.mail.business.model.EntityJoinRequestAcceptedMailModel;
import de.justsoftware.onx.mail.business.model.EntityMailModel;
import de.justsoftware.onx.mail.business.model.EntityMailModels;
import de.justsoftware.onx.mail.business.model.FooterMailModel;
import de.justsoftware.onx.mail.business.model.HeaderMailModel;
import de.justsoftware.onx.mail.business.model.MailReceiver;
import de.justsoftware.onx.mail.business.model.MailReceivers;
import de.justsoftware.onx.mail.business.model.ThemeMailModel;
import de.justsoftware.onx.mail.i18n.EntityMails;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.model.DBPerson;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class EntityJoinRequestAcceptedMailServiceImpl
implements EntityJoinRequestAcceptedMailService {
    private final MailService _mailService;
    private final MailModelService _mailModelService;
    private final I18nService _i18nService;
    private final PersonService _personService;
    private final Settings _settings;

    @Autowired
    public EntityJoinRequestAcceptedMailServiceImpl(MailService mailService, MailModelService mailModelService, I18nService i18nService, PersonService personService, Settings settings) {
        this._mailService = mailService;
        this._mailModelService = mailModelService;
        this._i18nService = i18nService;
        this._personService = personService;
        this._settings = settings;
    }

    @Override
    public void sendJoinRequestAcceptedMail(DBPerson sender, DBPerson receiver, DBEntity entity) {
        if (this._personService.getEmailNotificationEnabledPersons((Set<PersonId>)ImmutableSet.of((Object)receiver.getId())).isEmpty()) {
            return;
        }
        MailReceiver receiverModel = MailReceivers.forPerson(receiver, this._settings);
        EntityMails entityMails = this._i18nService.getEntityMailsByEntityType(entity.getType(), receiverModel.getLocale().getLanguage());
        EntityJoinRequestAcceptedMailModelImpl mailModel = new EntityJoinRequestAcceptedMailModelImpl(EntityMailModels.createForDBEntity(entity), entityMails.joinRequestAcceptedSubject(sender.getFullName(), entity.getType(), entity.getName()), sender.getFullName(), sender.getId(), receiverModel, this._mailModelService.getHeaderMailModel(), this._mailModelService.getFooterMailModel(), this._mailModelService.getThemeMailModel());
        this._mailService.sendEmail(mailModel);
    }

    @ParametersAreNonnullByDefault
    public static class EntityJoinRequestAcceptedMailModelImpl
    implements EntityJoinRequestAcceptedMailModel {
        private final EntityMailModel _entity;
        private final String _subject;
        private final String _senderName;
        private final PersonId _senderId;
        private final MailReceiver _receiver;
        private final HeaderMailModel _header;
        private final FooterMailModel _footer;
        private final ThemeMailModel _theme;

        public EntityJoinRequestAcceptedMailModelImpl(EntityMailModel entity, String subject, String senderName, PersonId senderId, MailReceiver receiver, HeaderMailModel header, FooterMailModel footer, ThemeMailModel theme) {
            this._entity = entity;
            this._subject = subject;
            this._senderName = senderName;
            this._senderId = senderId;
            this._receiver = receiver;
            this._header = header;
            this._footer = footer;
            this._theme = theme;
        }

        @Override
        public EntityMailModel getEntity() {
            return this._entity;
        }

        @Override
        public String getSubject() {
            return this._subject;
        }

        @Override
        public MailReceiver getReceiver() {
            return this._receiver;
        }

        @Override
        public HeaderMailModel getHeader() {
            return this._header;
        }

        @Override
        public FooterMailModel getFooter() {
            return this._footer;
        }

        @Override
        public ThemeMailModel getTheme() {
            return this._theme;
        }

        @Override
        public String getSenderName() {
            return this._senderName;
        }

        @Override
        public PersonId getSenderId() {
            return this._senderId;
        }
    }
}

