/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.mail.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.business.InternalLinkService;
import de.justsoftware.onx.mail.business.ChatMailService;
import de.justsoftware.onx.mail.business.MailModelService;
import de.justsoftware.onx.mail.business.MailService;
import de.justsoftware.onx.mail.business.model.ChatInfo;
import de.justsoftware.onx.mail.business.model.ChatListMailModel;
import de.justsoftware.onx.mail.business.model.FooterMailModel;
import de.justsoftware.onx.mail.business.model.HeaderMailModel;
import de.justsoftware.onx.mail.business.model.MailReceiver;
import de.justsoftware.onx.mail.business.model.MailReceivers;
import de.justsoftware.onx.mail.business.model.ThemeMailModel;
import de.justsoftware.onx.mail.i18n.EmailMessages;
import de.justsoftware.onx.person.model.DBPerson;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class ChatMailServiceImpl
implements ChatMailService {
    private final MailService _mailService;
    private final MailModelService _mailModelService;
    private final Settings _settings;
    private final I18nService _i18nService;
    private final InternalLinkService _internalLinkService;

    @Autowired
    public ChatMailServiceImpl(MailService mailService, MailModelService mailModelService, Settings settings, I18nService i18nService, InternalLinkService internalLinkService) {
        this._mailService = mailService;
        this._mailModelService = mailModelService;
        this._settings = settings;
        this._i18nService = i18nService;
        this._internalLinkService = internalLinkService;
    }

    @Override
    public void sendChatMail(List<ChatInfo> chatInfo, DBPerson receiver) {
        if (receiver.isBlocked() || !receiver.isActive()) {
            return;
        }
        MailReceiver mailReceiver = MailReceivers.forPerson(receiver, this._settings);
        EmailMessages mailMessages = this._i18nService.createProxy(EmailMessages.class, mailReceiver.getLocale().getLanguage());
        long unreadMessageCount = chatInfo.stream().mapToLong(ChatInfo::getUnreadMessageCount).sum();
        ImmutableList chatMailModels = (ImmutableList)chatInfo.stream().map(unreadChatInfo -> {
            String chatUrl = this._internalLinkService.makeURL("#/chat/" + unreadChatInfo.getChatId());
            String title = unreadChatInfo.getTitle() == null ? mailMessages.unknownUser() : unreadChatInfo.getTitle();
            return new ChatMailModelImpl(title, chatUrl, unreadChatInfo.getUnreadMessageCount());
        }).collect(ImmutableList.toImmutableList());
        String subject = mailMessages.newMessagesInChatsSubject(unreadMessageCount);
        String buttonUrl = this._internalLinkService.makeURL("#/chat/");
        this._mailService.sendEmail(new ChatListMailModelImpl(mailReceiver, subject, buttonUrl, (ImmutableList<ChatListMailModel.ChatMailModel>)chatMailModels, unreadMessageCount));
    }

    @ParametersAreNonnullByDefault
    private final class ChatListMailModelImpl
    implements ChatListMailModel {
        private final MailReceiver _receiver;
        private final String _subject;
        private final String _buttonUrl;
        private final long _unreadMessageCount;
        private final ImmutableList<ChatListMailModel.ChatMailModel> _chatMailModels;

        public ChatListMailModelImpl(MailReceiver mailReceiver, String subject, String buttonUrl, ImmutableList<ChatListMailModel.ChatMailModel> chatMailModels, long unreadMessageCount) {
            this._receiver = mailReceiver;
            this._subject = subject;
            this._buttonUrl = buttonUrl;
            this._unreadMessageCount = unreadMessageCount;
            this._chatMailModels = chatMailModels;
        }

        @Override
        public MailReceiver getReceiver() {
            return this._receiver;
        }

        @Override
        public String getSubject() {
            return this._subject;
        }

        @Override
        public String getButtonUrl() {
            return this._buttonUrl;
        }

        @Override
        public long getUnreadMessageCount() {
            return this._unreadMessageCount;
        }

        @Override
        public ImmutableList<ChatListMailModel.ChatMailModel> getChatMailModels() {
            return this._chatMailModels;
        }

        @Override
        public HeaderMailModel getHeader() {
            return ChatMailServiceImpl.this._mailModelService.getHeaderMailModel();
        }

        @Override
        public FooterMailModel getFooter() {
            return ChatMailServiceImpl.this._mailModelService.getFooterMailModel();
        }

        @Override
        public ThemeMailModel getTheme() {
            return ChatMailServiceImpl.this._mailModelService.getThemeMailModel();
        }
    }

    private static final class ChatMailModelImpl
    implements ChatListMailModel.ChatMailModel {
        private final String _title;
        private final String _chatUrl;
        private final long _unreadMessageCount;

        public ChatMailModelImpl(String title, String chatUrl, long unreadMessageCount) {
            this._title = title;
            this._chatUrl = chatUrl;
            this._unreadMessageCount = unreadMessageCount;
        }

        @Override
        public String getTitle() {
            return this._title;
        }

        @Override
        public String getChatUrl() {
            return this._chatUrl;
        }

        @Override
        public long getUnreadMessageCount() {
            return this._unreadMessageCount;
        }
    }
}

