/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.mail.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.mail.business.ActivationLinkMailService;
import de.justsoftware.onx.mail.business.MailModelService;
import de.justsoftware.onx.mail.business.MailService;
import de.justsoftware.onx.mail.business.model.ActivationLinkMailModel;
import de.justsoftware.onx.mail.business.model.EntityMailModel;
import de.justsoftware.onx.mail.business.model.EntityMailModels;
import de.justsoftware.onx.mail.business.model.FooterMailModel;
import de.justsoftware.onx.mail.business.model.HeaderMailModel;
import de.justsoftware.onx.mail.business.model.MailReceiver;
import de.justsoftware.onx.mail.business.model.MailReceivers;
import de.justsoftware.onx.mail.business.model.ThemeMailModel;
import de.justsoftware.onx.mail.i18n.EmailMessages;
import de.justsoftware.onx.person.model.DBPerson;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivationLinkMailServiceImpl
implements ActivationLinkMailService {
    private final MailModelService _mailModelService;
    private final I18nService _i18nService;
    private final MailService _mailService;
    private final Settings _settings;

    @Autowired
    @ParametersAreNonnullByDefault
    public ActivationLinkMailServiceImpl(MailModelService mailModelService, I18nService i18nService, MailService mailService, Settings settings) {
        this._mailModelService = mailModelService;
        this._i18nService = i18nService;
        this._mailService = mailService;
        this._settings = settings;
    }

    @Override
    public boolean sendActivationLinkMail(DBPerson person, String activationLink) {
        return this.sendActivationLinkMail(person, null, activationLink);
    }

    @Override
    public boolean sendActivationLinkMail(DBPerson person, DBEntity entity, String activationLink) {
        if (person.isBlocked()) {
            return false;
        }
        String subject = this._i18nService.createProxy(EmailMessages.class, person.getLanguageId()).confirmEmailForPlattform(this._settings.getDefaultSiteTitle());
        ActivationLinkMailModelImpl mailModel = new ActivationLinkMailModelImpl(MailReceivers.forPerson(person, this._settings), this._mailModelService.getHeaderMailModel(), this._mailModelService.getFooterMailModel(), this._mailModelService.getThemeMailModel(), subject, activationLink, entity);
        return this._mailService.sendEmailImmediately(mailModel);
    }

    private static class ActivationLinkMailModelImpl
    implements ActivationLinkMailModel {
        private final MailReceiver _receiver;
        private final HeaderMailModel _header;
        private final FooterMailModel _footer;
        private final String _subject;
        private final String _activationLink;
        private final ThemeMailModel _themeMailModel;
        private final EntityMailModel _entityMailModel;

        public ActivationLinkMailModelImpl(@Nonnull MailReceiver receiver, @Nonnull HeaderMailModel header, @Nonnull FooterMailModel footer, @Nonnull ThemeMailModel themeMailModel, @Nonnull String subject, @Nonnull String activationLink, @Nullable DBEntity entity) {
            this._receiver = receiver;
            this._header = header;
            this._footer = footer;
            this._themeMailModel = themeMailModel;
            this._subject = subject;
            this._activationLink = activationLink;
            this._entityMailModel = entity != null ? EntityMailModels.createForDBEntity(entity) : null;
        }

        @Override
        public MailReceiver getReceiver() {
            return this._receiver;
        }

        @Override
        public FooterMailModel getFooter() {
            return this._footer;
        }

        @Override
        public HeaderMailModel getHeader() {
            return this._header;
        }

        @Override
        public String getSubject() {
            return this._subject;
        }

        @Override
        public String getActivationLink() {
            return this._activationLink;
        }

        @Override
        public ThemeMailModel getTheme() {
            return this._themeMailModel;
        }

        @Override
        public EntityMailModel getEntity() {
            return this._entityMailModel;
        }
    }
}

