/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.mail.business.freemarker;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.io.ByteSource;
import de.justsoftware.mail.freemarker.EmbeddedImageBuilder;
import de.justsoftware.mail.freemarker.FreemarkerDirectiveUtils;
import de.justsoftware.mail.freemarker.FreemarkerRenderMode;
import de.justsoftware.mail.freemarker.SimpleFreemarkerDirective;
import de.justsoftware.onx.common.business.InternalLinkService;
import de.justsoftware.onx.common.shared.server.util.DOMUtil;
import de.justsoftware.onx.common.shared.server.util.HtmlParserUtil;
import de.justsoftware.onx.common.shared.server.util.NodeVisitor;
import de.justsoftware.onx.storage.business.StorageServerService;
import freemarker.core.Environment;
import freemarker.template.TemplateException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class UserHtmlDirective
extends SimpleFreemarkerDirective {
    private static final String STYLE_ATTR = "style";
    private final InternalLinkService _internalLinkService;
    private final StorageServerService _storageServerService;

    @ParametersAreNonnullByDefault
    public UserHtmlDirective(InternalLinkService internalLinkService, StorageServerService storageServerService) {
        this._internalLinkService = internalLinkService;
        this._storageServerService = storageServerService;
    }

    @Override
    protected String loadString(Map<String, ?> params, Environment env) throws TemplateException, IOException {
        return this.render(FreemarkerDirectiveUtils.getStringParameter("html", params, env), env);
    }

    @Nonnull
    @VisibleForTesting
    String render(@Nonnull String html, final @Nonnull Environment environment) throws IOException, TemplateException {
        Document document;
        try {
            document = HtmlParserUtil.parseHtml(html);
        }
        catch (SAXException e) {
            throw new TemplateException("Paramater \"html\" contains invalid html: ", (Exception)e, environment);
        }
        this.replaceLinks(document);
        return FreemarkerDirectiveUtils.getRenderMode(environment).accept(new FreemarkerRenderMode.FreemarkerRenderTypeVisitor<String>(){

            @Override
            public String visitText() {
                return UserHtmlDirective.this.htmlToText(document, environment);
            }

            @Override
            public String visitHtml() throws TemplateException, IOException {
                UserHtmlDirective.replaceCss(document);
                UserHtmlDirective.this.replaceImages(document, environment);
                return UserHtmlDirective.this.htmlToHtml(document, environment);
            }
        });
    }

    private void replaceLinks(@Nonnull Document document) {
        for (Node link : DOMUtil.nodeListIterable(document.getElementsByTagName("a"))) {
            String hrefValue;
            Node href = DOMUtil.getAttribute(link, "href");
            if (href == null || !(hrefValue = StringUtils.trimToEmpty((String)href.getNodeValue())).startsWith("#")) continue;
            href.setNodeValue(this._internalLinkService.makeURL(hrefValue));
        }
    }

    private void replaceImages(@Nonnull Document document, @Nonnull Environment environment) throws IOException {
        for (Node image : DOMUtil.nodeListIterable(document.getElementsByTagName("img"))) {
            Node src = DOMUtil.getAttribute(image, "src");
            if (src == null) continue;
            String url = StringUtils.trimToEmpty((String)src.getNodeValue());
            EmbeddedImageBuilder builder = EmbeddedImageBuilder.create(environment, url);
            builder.setExternalUrl(this._internalLinkService.makeRelativeUrlAbsolute(url));
            ByteSource source = this._storageServerService.loadIfFromStorageServer(url);
            if (source != null) {
                builder.setAttachmentData(source);
            }
            src.setNodeValue(builder.buildAndReturnNewUrl());
        }
    }

    private static void replaceCss(@Nonnull Document document) {
        Element div = document.createElement("div");
        div.setAttribute(STYLE_ATTR, "font-family:'Lucida Grande',Arial,Helvetica,sans-serif;font-size:12px;line-height:18px;text-align:left;word-wrap:break-word;");
        for (Node node : DOMUtil.nodeListIterable(document.getChildNodes())) {
            div.appendChild(node);
        }
        document.appendChild(div);
        UserHtmlDirective.addElementStyle(document, "h1", "font-size:18px;font-weight:bold;line-height:30px;");
        UserHtmlDirective.addElementStyle(document, "h2", "font-size:14px;font-weight:bold;line-height:30px;");
        UserHtmlDirective.addElementStyle(document, "h3", "font-size:12px;font-weight:bold;line-height:30px;");
        UserHtmlDirective.addElementStyle(document, "ul", "margin: 0; padding:0 0 9px 25px;");
        UserHtmlDirective.addElementStyle(document, "ol", "margin: 0; padding:0 0 9px 25px;");
    }

    private static void addElementStyle(@Nonnull Document document, @Nonnull String tag, @Nonnull String style) {
        Iterable elements = Iterables.filter(DOMUtil.nodeListIterable(document.getElementsByTagName(tag)), Element.class);
        for (Element element : elements) {
            element.setAttribute(STYLE_ATTR, style + StringUtils.trimToEmpty((String)element.getAttribute(STYLE_ATTR)));
        }
    }

    @Nonnull
    private String htmlToText(@Nonnull Document document, final @Nonnull Environment environment) {
        final StringBuilder stringBuilder = new StringBuilder();
        new NodeVisitor<Void, RuntimeException>(){

            @Override
            public NodeVisitor.Result<Void> visitElementStart(Element node) {
                String tagName = StringUtils.trimToEmpty((String)node.getNodeName()).toLowerCase(Locale.US);
                if (ImmutableSet.of((Object)"head", (Object)"meta").contains((Object)tagName)) {
                    return this.skipToNextSibling();
                }
                return this.visitChildren();
            }

            @Override
            public NodeVisitor.Result<Void> visitElementEnd(Element node) {
                String tagName = StringUtils.trimToEmpty((String)node.getNodeName()).toLowerCase(Locale.US);
                if ("a".equals(tagName)) {
                    String href = StringUtils.trimToNull((String)DOMUtil.getAttributeValue(node, "href"));
                    if (href != null) {
                        stringBuilder.append(" <").append(href).append("> ");
                    }
                } else if (ImmutableSet.of((Object)"p", (Object)"br").contains((Object)tagName)) {
                    stringBuilder.append("\n");
                }
                return this.visitChildren();
            }

            @Override
            public NodeVisitor.Result<Void> visitAttribute(Attr node) {
                return this.visitChildren();
            }

            @Override
            public NodeVisitor.Result<Void> visitTextNode(Text node) {
                return this.appendText(node.getNodeValue());
            }

            @Nonnull
            private NodeVisitor.Result<Void> appendText(@Nonnull String nodeValue) {
                stringBuilder.append(FreemarkerDirectiveUtils.escapeText(environment, nodeValue.replaceAll("\\s+", " ")));
                return this.visitChildren();
            }

            @Override
            protected NodeVisitor.Result<Void> visitCData(CDATASection node) {
                return this.appendText(node.getNodeValue());
            }

            @Override
            protected NodeVisitor.Result<Void> visitUnknown(Node node) {
                return this.visitChildren();
            }
        }.accept(document);
        return stringBuilder.toString();
    }

    @Nonnull
    private String htmlToHtml(@Nonnull Document document, @Nonnull Environment environment) throws TemplateException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Charset charset = FreemarkerDirectiveUtils.getContext(environment).getCharset();
            XMLStreamWriter xsw = XMLOutputFactory.newFactory().createXMLStreamWriter(baos, charset.name());
            new HtmlToHtmlNodeVisitor(xsw).accept(document);
            xsw.writeEndDocument();
            xsw.flush();
            return new String(baos.toByteArray(), charset);
        }
        catch (XMLStreamException e) {
            throw new TemplateException((Exception)e, environment);
        }
    }

    private static final class HtmlToHtmlNodeVisitor
    extends NodeVisitor<Void, XMLStreamException> {
        private final XMLStreamWriter _xsw;

        private HtmlToHtmlNodeVisitor(@Nonnull XMLStreamWriter xsw) {
            this._xsw = xsw;
        }

        @Override
        public NodeVisitor.Result<Void> visitElementStart(Element node) throws XMLStreamException {
            String tagName = StringUtils.trimToEmpty((String)node.getNodeName()).toLowerCase(Locale.US);
            if (ImmutableSet.of((Object)"head", (Object)"meta").contains((Object)tagName)) {
                return this.skipToNextSibling();
            }
            if (ImmutableSet.of((Object)"html", (Object)"body").contains((Object)tagName)) {
                return this.skipElementEnd();
            }
            boolean hasChildNodes = node.hasChildNodes();
            if (hasChildNodes) {
                this._xsw.writeStartElement(tagName);
            } else {
                this._xsw.writeEmptyElement(tagName);
            }
            NamedNodeMap attrMap = node.getAttributes();
            if (attrMap != null) {
                for (int i = 0; i < attrMap.getLength(); ++i) {
                    Node attrNode = attrMap.item(i);
                    String attributeName = attrNode.getNodeName();
                    if (ImmutableSet.of((Object)"class").contains((Object)StringUtils.lowerCase((String)attributeName))) continue;
                    this._xsw.writeAttribute(attributeName, attrNode.getNodeValue());
                }
            }
            if (hasChildNodes) {
                return this.visitChildren();
            }
            return this.skipToNextSibling();
        }

        @Override
        public NodeVisitor.Result<Void> visitElementEnd(Element node) throws XMLStreamException {
            this._xsw.writeEndElement();
            return this.visitChildren();
        }

        @Override
        public NodeVisitor.Result<Void> visitAttribute(Attr node) {
            return this.visitChildren();
        }

        @Override
        public NodeVisitor.Result<Void> visitTextNode(Text node) throws XMLStreamException {
            this._xsw.writeCharacters(node.getNodeValue());
            return this.visitChildren();
        }

        @Override
        protected NodeVisitor.Result<Void> visitCData(CDATASection node) throws XMLStreamException {
            this._xsw.writeCData(node.getNodeValue());
            return this.visitChildren();
        }

        @Override
        protected NodeVisitor.Result<Void> visitUnknown(Node node) {
            return this.visitChildren();
        }
    }
}

