/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.mail.business.freemarker;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.mail.freemarker.FreemarkerDirectiveUtils;
import de.justsoftware.mail.freemarker.FreemarkerRenderMode;
import de.justsoftware.mail.freemarker.SimpleFreemarkerDirective;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.mail.business.model.EntityMailModel;
import freemarker.core.Environment;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class TranslationDirective
extends SimpleFreemarkerDirective {
    private static final ImmutableSetMultimap<Class<?>, Class<?>> CAN_BE_WIDEN_TO = ImmutableSetMultimap.builder().put(Boolean.class, Boolean.TYPE).putAll(Byte.class, (Object[])new Class[]{Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE}).putAll(Short.class, (Object[])new Class[]{Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE}).putAll(Character.class, (Object[])new Class[]{Character.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE}).putAll(Integer.class, (Object[])new Class[]{Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE}).putAll(Long.class, (Object[])new Class[]{Long.TYPE, Float.TYPE, Double.TYPE}).putAll(Float.class, (Object[])new Class[]{Float.TYPE, Double.TYPE}).put(Double.class, Double.TYPE).build();
    private final I18nService _i18nService;

    @Autowired
    public TranslationDirective(@Nonnull I18nService i18nService) {
        this._i18nService = i18nService;
    }

    @Override
    protected String loadString(Map<String, ?> params, final Environment env) throws TemplateException, IOException {
        try {
            String result;
            String msgWithCrNl;
            String key = FreemarkerDirectiveUtils.getStringParameter("key", params, env);
            Boolean raw = FreemarkerDirectiveUtils.getNullableBooleanParameter("raw", params);
            String[] keyArray = StringUtils.split((String)key, (char)'.');
            if (keyArray.length != 2) {
                throw new TemplateException("Parameter \"key\" (\"" + key + "\") has to contain exact 1 '.'.", env);
            }
            String clz = keyArray[0];
            String method = keyArray[1];
            EntityType entityType = this.getEntityType(clz, params, env);
            Object proxy = this._i18nService.createProxy(clz, entityType, env.getLocale().getLanguage());
            Object[] paramsWithPlaceHolder = (Object[])MoreObjects.firstNonNull((Object)FreemarkerDirectiveUtils.getNullableValue(Object[].class, "params", params, env), (Object)new Object[0]);
            ImmutableMap<String, String> replacementMap = TranslationDirective.replace(paramsWithPlaceHolder);
            try {
                msgWithCrNl = (String)TranslationDirective.findMethod(proxy.getClass(), method, paramsWithPlaceHolder).invoke(proxy, paramsWithPlaceHolder);
            }
            catch (NoSuchMethodException e) {
                throw new TemplateException("No method \"" + method + "\" found", env);
            }
            if (Boolean.TRUE.equals(raw)) {
                result = msgWithCrNl;
            } else {
                final String msgWithNl = StringUtils.remove((String)msgWithCrNl, (char)'\r');
                FreemarkerRenderMode renderMode = FreemarkerDirectiveUtils.getRenderMode(env);
                result = renderMode.accept(new FreemarkerRenderMode.FreemarkerRenderTypeVisitor<String>(){

                    @Override
                    public String visitText() {
                        return FreemarkerDirectiveUtils.escapeText(env, msgWithNl);
                    }

                    @Override
                    public String visitHtml() {
                        return StringUtils.replace((String)FreemarkerDirectiveUtils.escapeHtml(msgWithNl), (String)"\n", (String)"<br/>");
                    }
                });
            }
            return FreemarkerDirectiveUtils.replaceEach(result, replacementMap);
        }
        catch (IllegalAccessException e) {
            throw new TemplateException((Exception)e, env);
        }
        catch (InvocationTargetException e) {
            throw new TemplateException((Exception)e, env);
        }
        catch (RuntimeException e) {
            throw new TemplateException((Exception)e, env);
        }
    }

    @CheckForNull
    private EntityType getEntityType(@Nonnull String clz, @Nonnull Map<String, ?> params, @Nonnull Environment env) throws TemplateException {
        if (this._i18nService.getDimensionType(clz) != I18nService.DimensionType.ENTITY_TYPE) {
            return null;
        }
        Object rawEntityType = FreemarkerDirectiveUtils.getNullableValue(Object.class, "entityType", params, env);
        if (rawEntityType != null) {
            if (rawEntityType instanceof EntityType) {
                return (EntityType)rawEntityType;
            }
            EntityType result = EntityType.getEntityTypeByName(rawEntityType.toString());
            if (result == null) {
                throw new TemplateException("Paramater \"entityType\" is not defined", env);
            }
            return result;
        }
        TemplateModel global = env.getGlobalVariable("entity");
        EntityMailModel entityMailModel = FreemarkerDirectiveUtils.getNullableValueRecursive(EntityMailModel.class, "entity", global, env);
        if (entityMailModel == null) {
            throw new TemplateException("Paramater \"entityType\" is not defined", env);
        }
        return entityMailModel.getType();
    }

    @Nonnull
    private static ImmutableMap<String, String> replace(@Nonnull Object[] paramsWithPlaceHolder) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (int i = 0; i < paramsWithPlaceHolder.length; ++i) {
            if (!(paramsWithPlaceHolder[i] instanceof String)) continue;
            String placeHolder = FreemarkerDirectiveUtils.createPlaceholder(i);
            result.put((Object)placeHolder, (Object)((String)paramsWithPlaceHolder[i]));
            paramsWithPlaceHolder[i] = placeHolder;
        }
        return result.build();
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    @VisibleForTesting
    static Method findMethod(Class<?> clz, String methodName, Object[] params) throws NoSuchMethodException {
        if (params.length == 0) {
            Method m = clz.getMethod(methodName, new Class[0]);
            if (String.class.isAssignableFrom(m.getReturnType())) {
                return m;
            }
        } else {
            for (Method m : clz.getMethods()) {
                if (!TranslationDirective.isCallable(methodName, params, m)) continue;
                return m;
            }
        }
        throw new NoSuchMethodException();
    }

    @ParametersAreNonnullByDefault
    private static boolean isCallable(String methodName, Object[] params, Method m) {
        if (!m.getName().equals(methodName) || !String.class.isAssignableFrom(m.getReturnType())) {
            return false;
        }
        Class<?>[] parameterTypes = m.getParameterTypes();
        if (parameterTypes.length != params.length) {
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (TranslationDirective.canBeWidenTo(parameterTypes[i], params[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean canBeWidenTo(@Nonnull Class<?> type, @Nullable Object param) {
        return param != null && (type.isInstance(param) || CAN_BE_WIDEN_TO.get(param.getClass()).contains(type)) || param == null && !type.isPrimitive();
    }
}

