/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.mail.business.freemarker;

import com.freiheit.toro.common.shared.util.ImageUrlUtil;
import de.justsoftware.mail.freemarker.EmbeddedImageBuilder;
import de.justsoftware.mail.freemarker.FreemarkerDirectiveUtils;
import de.justsoftware.mail.freemarker.SimpleFreemarkerDirective;
import de.justsoftware.onx.common.shared.util.Resources2;
import de.justsoftware.onx.storage.business.StorageServerService;
import freemarker.core.Environment;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class StorageServerImageDirective
extends SimpleFreemarkerDirective {
    private final StorageServerService _storageServerService;

    public StorageServerImageDirective(@Nonnull StorageServerService storageServerService) {
        this._storageServerService = storageServerService;
    }

    @Override
    protected String loadString(Map<String, ?> params, Environment env) throws TemplateException, IOException {
        String path = FreemarkerDirectiveUtils.getStringParameter("path", params, env);
        String mimeType = FreemarkerDirectiveUtils.getNullableStringParameter("mimeType", params, env);
        EmbeddedImageBuilder builder = EmbeddedImageBuilder.create(env, path);
        if (mimeType != null) {
            builder.setContentType(mimeType);
        }
        if (StringUtils.startsWithIgnoreCase((String)path, (String)"//")) {
            this.setExternalAttachment("http:" + path, builder);
        } else if (StringUtils.startsWithIgnoreCase((String)path, (String)"https:") || StringUtils.startsWithIgnoreCase((String)path, (String)"http:") || StringUtils.startsWithIgnoreCase((String)path, (String)"file:") || StringUtils.startsWithIgnoreCase((String)path, (String)"jar:")) {
            this.setExternalAttachment(path, builder);
        } else {
            builder.setAttachmentData(this._storageServerService.loadFileFromStorageServer(path));
            builder.setExternalUrl(ImageUrlUtil.appendServer(path));
        }
        return builder.buildAndReturnNewUrl();
    }

    private void setExternalAttachment(@Nonnull String path, @Nonnull EmbeddedImageBuilder builder) throws MalformedURLException {
        builder.setAttachmentData(Resources2.asByteSource(new URL(path), 60000));
        builder.setExternalUrl(path);
    }
}

