/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.mail.business.freemarker;

import com.google.common.base.MoreObjects;
import de.justsoftware.mail.freemarker.FreemarkerDirectiveUtils;
import de.justsoftware.mail.freemarker.SimpleFreemarkerDirective;
import de.justsoftware.onx.common.business.InternalLinkService;
import de.justsoftware.onx.common.shared.model.LongId;
import de.justsoftware.onx.common.shared.model.StringId;
import de.justsoftware.onx.common.shared.server.util.TokenUtilServer;
import de.justsoftware.onx.common.shared.util.HistoryToken;
import freemarker.core.Environment;
import freemarker.template.TemplateException;
import java.util.Map;
import javax.annotation.Nonnull;

public class JucoUrlDirective
extends SimpleFreemarkerDirective {
    private final InternalLinkService _internalLinkService;

    public JucoUrlDirective(@Nonnull InternalLinkService internalLinkService) {
        this._internalLinkService = internalLinkService;
    }

    @Override
    protected String loadString(Map<String, ?> params, Environment env) throws TemplateException {
        String path = FreemarkerDirectiveUtils.getNullableStringParameter("path", params, env);
        if (path != null) {
            return this._internalLinkService.addHost(path);
        }
        HistoryToken token = (HistoryToken)((Object)MoreObjects.firstNonNull((Object)((Object)FreemarkerDirectiveUtils.getEnumValue(HistoryToken.class, "token", params, env)), (Object)((Object)HistoryToken.HOME)));
        Object[] paramArray = (Object[])MoreObjects.firstNonNull((Object)FreemarkerDirectiveUtils.getNullableValue(Object[].class, "params", params, env), (Object)new Object[0]);
        StringBuilder paramTypes = new StringBuilder();
        for (int i = 0; i < paramArray.length; ++i) {
            if (paramArray[i] instanceof LongId) {
                paramArray[i] = Long.toString(((LongId)paramArray[i]).getId());
            } else if (paramArray[i] instanceof StringId) {
                paramArray[i] = ((StringId)paramArray[i]).getId();
            }
            if (paramArray[i] == null || paramArray[i] instanceof String) {
                paramTypes.append('S');
                continue;
            }
            if (paramArray[i] instanceof Boolean) {
                paramTypes.append('B');
                continue;
            }
            if (paramArray[i] instanceof Number) {
                paramTypes.append('L');
                paramArray[i] = ((Number)paramArray[i]).longValue();
                continue;
            }
            paramTypes.append('S');
            paramArray[i] = paramArray[i].toString();
        }
        String tokenString = TokenUtilServer.createToken(token, paramTypes.toString(), paramArray);
        return this._internalLinkService.makeAbsolute(tokenString);
    }
}

