/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.mail.business.freemarker;

import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import de.justsoftware.mail.EmailRenderService;
import de.justsoftware.onx.mail.business.MailSender;
import de.justsoftware.onx.mail.business.MailService;
import de.justsoftware.onx.mail.business.freemarker.MailServiceImpl;
import de.justsoftware.onx.mail.business.model.DefaultMailModel;
import de.justsoftware.onx.mail.business.model.ProfileDataMailModel;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="mailService")
public class AsyncMailServiceImpl
implements MailService {
    private final MailService _mailService;
    private final ExecutorService _executorService = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("MailQueue-%d").build());

    @ParametersAreNonnullByDefault
    @Autowired
    public AsyncMailServiceImpl(EmailRenderService emailRenderService, MailSender mailSender) {
        this._mailService = new MailServiceImpl(emailRenderService, mailSender);
    }

    @Override
    public void sendProfileData(ProfileDataMailModel model) {
        this._executorService.execute(() -> this._mailService.sendProfileData(model));
    }

    @Override
    public void sendEmail(DefaultMailModel mailDataModel) {
        this._executorService.execute(() -> this._mailService.sendEmail(mailDataModel));
    }

    @Override
    public boolean sendEmailImmediately(DefaultMailModel mailDataModel) {
        return this._mailService.sendEmailImmediately(mailDataModel);
    }

    @PreDestroy
    void shutdownExecutorService() {
        MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this._executorService, (long)1L, (TimeUnit)TimeUnit.MINUTES);
    }
}

