/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.mail.business;

import de.justsoftware.onx.mail.business.MailTemplateResolver;
import de.justsoftware.onx.mail.i18n.CommonMails;
import de.justsoftware.onx.mail.i18n.EntityMails;

public enum MailType implements MailTemplateResolver
{
    STATIC(new MailTemplateResolver(){

        @Override
        public String getTemplateString(CommonMails commonMails, EntityMails entityMails) {
            return "";
        }
    }),
    REPORT_BLOCKED_PERSON(new MailTemplateResolver(){

        @Override
        public String getTemplateString(CommonMails commonMails, EntityMails entityMails) {
            return commonMails.reportBlockedPerson();
        }
    }),
    IMPORTED_USER_GREETING(new MailTemplateResolver(){

        @Override
        public String getTemplateString(CommonMails commonMails, EntityMails entityMails) {
            return "";
        }
    }),
    MESSAGE_ENTITY(new MailTemplateResolver(){

        @Override
        public String getTemplateString(CommonMails commonMails, EntityMails entityMails) {
            return entityMails.messageEntity();
        }
    }),
    MESSAGE_ENTITY_HTML(new MailTemplateResolver(){

        @Override
        public String getTemplateString(CommonMails commonMails, EntityMails entityMails) {
            return entityMails.messageEntityHtml();
        }
    }),
    ENTITY_PARTICIPANT_LIST(new MailTemplateResolver(){

        @Override
        public String getTemplateString(CommonMails commonMails, EntityMails entityMails) {
            return entityMails.entityParticipantList();
        }
    }),
    ENTITY_DATA_CHANGED(new MailTemplateResolver(){

        @Override
        public String getTemplateString(CommonMails commonMails, EntityMails entityMails) {
            return entityMails.entityDataChanged();
        }
    }),
    ENTITY_VERSION_WAS_DECLINED_SUBJECT(new MailTemplateResolver(){

        @Override
        public String getTemplateString(CommonMails commonMails, EntityMails entityMails) {
            return entityMails.versionReviewDeclinedSubject();
        }
    }),
    ENTITY_VERSION_WAS_DECLINED(new MailTemplateResolver(){

        @Override
        public String getTemplateString(CommonMails commonMails, EntityMails entityMails) {
            return entityMails.versionReviewDeclinedText();
        }
    }),
    ENTITY_VERSION_WAS_ACCEPTED_SUBJECT(new MailTemplateResolver(){

        @Override
        public String getTemplateString(CommonMails commonMails, EntityMails entityMails) {
            return entityMails.versionReviewAcceptedSubject();
        }
    }),
    ENTITY_VERSION_WAS_ACCEPTED(new MailTemplateResolver(){

        @Override
        public String getTemplateString(CommonMails commonMails, EntityMails entityMails) {
            return entityMails.versionReviewAcceptedText();
        }
    }),
    ENTITY_VERSION_REVIEW_REQUEST_SUBJECT(new MailTemplateResolver(){

        @Override
        public String getTemplateString(CommonMails commonMails, EntityMails entityMails) {
            return entityMails.versionReviewRequestSubject();
        }
    }),
    ENTITY_VERSION_REVIEW_REQUEST(new MailTemplateResolver(){

        @Override
        public String getTemplateString(CommonMails commonMails, EntityMails entityMails) {
            return entityMails.versionReviewRequestText();
        }
    }),
    ENTITY_NEW_MEMBERSHIP_BY_IMPORT(new MailTemplateResolver(){

        @Override
        public String getTemplateString(CommonMails commonMails, EntityMails entityMails) {
            return ENTITY_PARTICIPANT_LIST.getTemplateString(commonMails, entityMails);
        }
    });

    private final MailTemplateResolver _mailTemplateResolver;

    private MailType(MailTemplateResolver mailTemplateResolver) {
        this._mailTemplateResolver = mailTemplateResolver;
    }

    @Override
    public String getTemplateString(CommonMails commonMails, EntityMails entityMails) {
        return this._mailTemplateResolver.getTemplateString(commonMails, entityMails);
    }
}

