/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.linkinfo.shared.model;

import com.google.common.base.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public enum LinkType implements Predicate<String>
{
    INTERNAL{

        public boolean apply(String input) {
            return input != null && input.startsWith("#");
        }
    }
    ,
    EXTERNAL{

        public boolean apply(String input) {
            return !INTERNAL.apply(input) && !MAILTO.apply(input);
        }
    }
    ,
    MAILTO{

        public boolean apply(String input) {
            return input != null && input.startsWith(LinkType.MAILTO_PREFIX);
        }
    };

    public static final String MAILTO_PREFIX = "mailto:";

    @Nonnull
    public static LinkType getLinkType(String url) {
        if (INTERNAL.apply(url)) {
            return INTERNAL;
        }
        if (MAILTO.apply(url)) {
            return MAILTO;
        }
        return EXTERNAL;
    }
}

