/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.link.shared.server.model;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import de.justsoftware.onx.common.shared.util.Dates;
import de.justsoftware.onx.link.shared.model.LinkId;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.util.Date;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LinkModel {
    public static final Function<LinkModel, String> TO_URL = new NullPermeableFunction<LinkModel, String>(){

        @Override
        protected String applySafe(LinkModel input) {
            return input.getUrl();
        }
    };
    private final LinkId _id;
    private final String _url;
    private final String _title;
    private final Date _createDate;
    private final Date _modifyDate;

    public LinkModel(@Nonnull LinkId id, @Nonnull String url, @Nullable String title, @Nonnull Date createDate, @Nullable Date modifyDate) {
        this._id = id;
        this._url = url;
        this._title = title;
        this._createDate = Dates.clone(createDate);
        this._modifyDate = Dates.clone(modifyDate);
    }

    @Nonnull
    public LinkId getId() {
        return this._id;
    }

    @Nonnull
    public String getUrl() {
        return this._url;
    }

    @CheckForNull
    public String getTitle() {
        return this._title;
    }

    @Nonnull
    public Date getCreateDate() {
        return Dates.clone(this._createDate);
    }

    @Nonnull
    public Date getModifyDate() {
        return Dates.clone(this._modifyDate);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("LinkId", (Object)this._id).add("url", (Object)this._url).add("title", (Object)this._title).add("createDate", (Object)this._createDate).add("modifyDate", (Object)this._modifyDate).toString();
    }
}

