/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.like.shared.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticItemAction;
import de.justsoftware.onx.like.shared.model.SubscriptionState;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class SubscriptionStatus
implements Serializable {
    private static final long serialVersionUID = -4330290073844922936L;
    private ImmutableSet<Action> _permissions;
    private SubscriptionState _state;
    private boolean _canSubscribeWithNotification;

    @Deprecated
    public SubscriptionStatus() {
    }

    public SubscriptionStatus(SubscriptionState state, ImmutableSet<Action> permissions, boolean canSubscribeWithNotification) {
        this._state = state;
        this._permissions = permissions;
        this._canSubscribeWithNotification = canSubscribeWithNotification;
    }

    @Nonnull
    public ImmutableSet<Action> getPermissions() {
        return this._permissions;
    }

    public boolean maySubscribe() {
        return !this._state.isSubscribed() && this._permissions.contains((Object)StaticItemAction.LIKE_SUBSCRIBE);
    }

    public boolean mayUnsubscribe() {
        return this._state.isSubscribed() && this._permissions.contains((Object)StaticItemAction.UNLIKE_UNSUBSCRIBE);
    }

    @Nonnull
    public SubscriptionState getState() {
        return this._state;
    }

    public boolean isCanSubscribeWithNotification() {
        return this._canSubscribeWithNotification;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("state", (Object)this._state).add("permissions", this._permissions == null ? null : Integer.valueOf(this._permissions.size())).add("canSubscribeWithNotification", this._canSubscribeWithNotification).toString();
    }
}

