/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.like.business.model;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.like.shared.model.SubscriptionState;
import de.justsoftware.onx.like.shared.model.SubscriptionType;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class SubscriptionModel
implements Serializable {
    public static final Function<SubscriptionModel, SubscriptionState> GET_STATE = new NullPermeableFunction<SubscriptionModel, SubscriptionState>(){

        @Override
        protected SubscriptionState applySafe(SubscriptionModel input) {
            return input.getState();
        }
    };
    public static final Function<SubscriptionModel, ItemId> GET_ITEM_ID = new NullPermeableFunction<SubscriptionModel, ItemId>(){

        @Override
        protected ItemId applySafe(SubscriptionModel input) {
            return input.getItemId();
        }
    };
    public static final Function<SubscriptionModel, PersonId> GET_SUBSCRIBER_ID = new NullPermeableFunction<SubscriptionModel, PersonId>(){

        @Override
        protected PersonId applySafe(SubscriptionModel input) {
            return input.getSubscriberId();
        }
    };
    public static final Predicate<SubscriptionModel> IS_SUBSCRIBED = Predicates.compose((Predicate)Predicates.in(SubscriptionState.SUBSCRIBED_SET), GET_STATE);
    private static final long serialVersionUID = 1L;
    private final ItemId _itemId;
    private final PersonId _subscriberId;
    private final SubscriptionState _state;
    private final SubscriptionType _type;

    public SubscriptionModel(ItemId itemId, PersonId subscriberId, SubscriptionState state, SubscriptionType type) {
        this._itemId = itemId;
        this._subscriberId = subscriberId;
        this._state = state;
        this._type = type;
    }

    @Nonnull
    public ItemId getItemId() {
        return this._itemId;
    }

    @Nonnull
    public PersonId getSubscriberId() {
        return this._subscriberId;
    }

    @Nonnull
    public SubscriptionState getState() {
        return this._state;
    }

    @Nonnull
    public SubscriptionType getType() {
        return this._type;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("itemId", (Object)this._itemId).add("subscriberId", (Object)this._subscriberId).add("state", (Object)this._state).add("type", (Object)this._type).toString();
    }
}

