/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.like.business.impl;

import com.freiheit.toro.cache.ehcache.EhCacheName;
import com.freiheit.toro.cache.ehcache.EhcacheClient;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Streams;
import com.google.common.collect.Table;
import de.justsoftware.onx.common.cache.AbstractMapLoadingCacheAccessor;
import de.justsoftware.onx.common.cache.AbstractRelationalCacheAccessor;
import de.justsoftware.onx.common.cache.AbstractSingleLoadingCacheAccessor;
import de.justsoftware.onx.common.cache.UniDirectionalCacheAccessor;
import de.justsoftware.onx.common.deletion.DeleteTransactionCallback;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.like.business.LikeReadDataService;
import de.justsoftware.onx.like.business.LikeWriteDataService;
import de.justsoftware.onx.like.business.model.SubscriptionModel;
import de.justsoftware.onx.like.integration.persistence.LikeDAO;
import de.justsoftware.onx.like.integration.persistence.model.SubscriptionWithDate;
import de.justsoftware.onx.like.shared.model.SubscriptionState;
import de.justsoftware.onx.like.shared.model.SubscriptionType;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

@Service(value="likeReadWriteDataService")
@ParametersAreNonnullByDefault
public class LikeReadWriteDataServiceImpl
implements LikeReadDataService,
LikeWriteDataService {
    private final LikeDAO _likeDAO;
    private final TransactionHelper _transactionHelper;
    private final LikesByPersonCacheAccessor _likesByPersonCacheAccessor;
    private final LikesCountCacheAccessor _likesCountCacheAccessor;
    private final UniDirectionalCacheAccessor<LikeServiceEhCacheName, ItemId, PersonId> _recentLikersCacheAccessor;
    private final AllLikesCacheAccessor _allLikesCacheAccessor;
    private final DirectSubscriptionsCacheAccessor _directSubscriptionsCacheAccessor;
    private final SubscriptionCountCacheAccessor _subscriptionCountCacheAccessor;

    @Autowired
    public LikeReadWriteDataServiceImpl(LikeDAO likeDAO, TransactionHelper transactionHelper, EhcacheClient ehCacheClient) {
        this._likeDAO = likeDAO;
        this._transactionHelper = transactionHelper;
        this._likesByPersonCacheAccessor = new LikesByPersonCacheAccessor(ehCacheClient, likeDAO);
        this._likesCountCacheAccessor = new LikesCountCacheAccessor(ehCacheClient, likeDAO);
        this._recentLikersCacheAccessor = this.createRecentLikersCacheAccessor(ehCacheClient, likeDAO);
        this._allLikesCacheAccessor = new AllLikesCacheAccessor(ehCacheClient, likeDAO);
        this._directSubscriptionsCacheAccessor = new DirectSubscriptionsCacheAccessor(ehCacheClient, likeDAO);
        this._subscriptionCountCacheAccessor = new SubscriptionCountCacheAccessor(ehCacheClient, likeDAO);
    }

    @Nonnull
    private UniDirectionalCacheAccessor<LikeServiceEhCacheName, ItemId, PersonId> createRecentLikersCacheAccessor(EhcacheClient ehCacheClient, LikeDAO likeDAO) {
        return new UniDirectionalCacheAccessor<LikeServiceEhCacheName, ItemId, PersonId>(ehCacheClient, LikeServiceEhCacheName.RECENT_LIKERS, likeDAO::getRecentLikers, ItemId::asString);
    }

    private void deleteCachesForLiker(PersonId key) {
        this._likesByPersonCacheAccessor.invalidateKey(key);
    }

    private void deleteCachesForItem(ItemId key) {
        this._likesCountCacheAccessor.invalidateKey(key);
        this._recentLikersCacheAccessor.invalidateKey(key);
        this._allLikesCacheAccessor.invalidateKey(key);
    }

    private void deleteCachesForSubscriptions(SetMultimap<? extends ItemId, PersonId> subscriptions) {
        this._directSubscriptionsCacheAccessor.invalidateKeys(subscriptions.entries());
        this._subscriptionCountCacheAccessor.invalidateKeys(subscriptions.keySet());
    }

    @Override
    public void like(ItemId id, PersonId liker) {
        this._likeDAO.like(id, liker);
        this.deleteCachesForItem(id);
        this.deleteCachesForLiker(liker);
    }

    @Override
    public void unlike(ItemId id, PersonId liker) {
        this._likeDAO.unlike(id, liker);
        this.deleteCachesForItem(id);
        this.deleteCachesForLiker(liker);
    }

    @Override
    public void setSubscriptionStateAndType(final SetMultimap<? extends ItemId, PersonId> subscriptions, final SubscriptionState state, final SubscriptionType type, final boolean forceTypeUpdate) {
        this._transactionHelper.doInTransactionWithoutResult(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                ImmutableSetMultimap<ItemId, PersonId> missingSubscriptions;
                ImmutableSetMultimap<ItemId, PersonId> immutableSetMultimap = missingSubscriptions = forceTypeUpdate ? LikeReadWriteDataServiceImpl.this._likeDAO.updateSubscriptions((SetMultimap<? extends ItemId, PersonId>)subscriptions, state, type) : LikeReadWriteDataServiceImpl.this._likeDAO.updateSubscriptions((SetMultimap<? extends ItemId, PersonId>)subscriptions, state);
                if (!missingSubscriptions.isEmpty()) {
                    LikeReadWriteDataServiceImpl.this._likeDAO.insertSubscriptions((SetMultimap<? extends ItemId, PersonId>)missingSubscriptions, state, type);
                }
            }
        });
        this.deleteCachesForSubscriptions(subscriptions);
    }

    @Override
    public void setSubscriptionWhenTypeDiffers(final SetMultimap<? extends ItemId, PersonId> subscriptions, final SubscriptionState state, final SubscriptionType type) {
        this._transactionHelper.doInTransactionWithoutResult(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                ImmutableSetMultimap<ItemId, PersonId> missingSubscriptions = LikeReadWriteDataServiceImpl.this._likeDAO.updateSubscriptionWhenTypeDiffers((SetMultimap<? extends ItemId, PersonId>)subscriptions, state, type);
                if (!missingSubscriptions.isEmpty()) {
                    LikeReadWriteDataServiceImpl.this._likeDAO.insertSubscriptions((SetMultimap<? extends ItemId, PersonId>)missingSubscriptions, state, type);
                }
            }
        });
        this.deleteCachesForSubscriptions(subscriptions);
    }

    @Override
    public ImmutableSetMultimap<EntityId, PersonId> getSubscriptionsByEntityTypesAndPersonIds(Set<EntityType> entityTypesForSubscriptions, Set<PersonId> personIds, SubscriptionType type) {
        return this._likeDAO.getSubscriptionsByEntityTypesAndPersonIds(entityTypesForSubscriptions, personIds, type);
    }

    @Override
    public DeleteTransactionCallback deleteAllForItem(final ItemId id) {
        this._likeDAO.deleteAllForItem(id);
        return new DeleteTransactionCallback(){

            @Override
            public void afterCommit() {
                LikeReadWriteDataServiceImpl.this.deleteCachesForItem(id);
            }
        };
    }

    @Override
    public ImmutableMap<ItemId, Integer> getLikesCount(Set<? extends ItemId> ids) {
        return this._likesCountCacheAccessor.getMap(ids);
    }

    @Override
    public ImmutableSet<ItemId> getLikesByPersonId(PersonId forPerson) {
        ImmutableSet result = forPerson != null ? (ImmutableSet)this._likesByPersonCacheAccessor.getSingle(forPerson) : null;
        return result != null ? result : ImmutableSet.of();
    }

    @Override
    public ImmutableList<SubscriptionModel> getSubscribers(Set<? extends ItemId> items) {
        return this._likeDAO.getSubscribers(items);
    }

    @Override
    public int getSubscribersCount(ItemId id) {
        Integer result = (Integer)this._subscriptionCountCacheAccessor.getSingle(id);
        return result != null ? result : 0;
    }

    @Override
    public ImmutableSetMultimap<ItemId, PersonId> getRecentLikers(Set<? extends ItemId> items) {
        return (ImmutableSetMultimap)this._recentLikersCacheAccessor.getMultiMap(items);
    }

    @Override
    public ImmutableSet<PersonId> getAllLikerIds(ItemId id) {
        ImmutableSet result = (ImmutableSet)this._allLikesCacheAccessor.getSingle(id);
        return result != null ? result : ImmutableSet.of();
    }

    @Override
    public ImmutableSetMultimap<ItemId, PersonId> hasPassiveSubscriptions(SetMultimap<ItemId, PersonId> subscriptions) {
        ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
        ImmutableTable<ItemId, PersonId, SubscriptionModel> dbSubscriptions = this.getExplicitSubscriptions(subscriptions);
        for (Map.Entry s : subscriptions.entries()) {
            SubscriptionModel db = (SubscriptionModel)dbSubscriptions.get(s.getKey(), s.getValue());
            if (db == null || db.getType() != SubscriptionType.PASSIVE || db.getState() != SubscriptionState.SUBSCRIBED) continue;
            result.put(s);
        }
        return result.build();
    }

    @Override
    public SubscriptionModel getExplicitSubscription(ItemId id, PersonId subscriber) {
        return (SubscriptionModel)this._directSubscriptionsCacheAccessor.getSingle(id, subscriber);
    }

    @Override
    public ImmutableTable<ItemId, PersonId, SubscriptionModel> getExplicitSubscriptions(SetMultimap<? extends ItemId, PersonId> subscriptions) {
        return this._directSubscriptionsCacheAccessor.getTable(subscriptions);
    }

    @Override
    public void refreshSubscriptionsCount() {
        this._subscriptionCountCacheAccessor.invalidateAll();
    }

    @Override
    public void subscribeAndOverwriteOldSubscriptions(Iterable<SubscriptionWithDate> subscriptions) {
        this._likeDAO.subscribeAndOverwriteOldSubscriptions(subscriptions);
        ImmutableSetMultimap personsPerItem = (ImmutableSetMultimap)Streams.stream(subscriptions).collect(ImmutableSetMultimap.toImmutableSetMultimap(SubscriptionWithDate::getItemId, SubscriptionWithDate::getSubscriberId));
        this.deleteCachesForSubscriptions((SetMultimap<? extends ItemId, PersonId>)personsPerItem);
    }

    @ParametersAreNonnullByDefault
    private static final class SubscriptionCountCacheAccessor
    extends AbstractSingleLoadingCacheAccessor<LikeServiceEhCacheName, ItemId, Integer> {
        private final LikeDAO _dao;

        private SubscriptionCountCacheAccessor(EhcacheClient cache, LikeDAO dao) {
            super(cache, LikeServiceEhCacheName.SUBSCRIPTION_COUNT);
            this._dao = dao;
        }

        @Override
        protected Integer getFromDatabaseSingle(ItemId id) {
            return this._dao.getSubscribersCount(id);
        }

        @Override
        protected String keyToString(ItemId key) {
            return key.asString();
        }
    }

    @ParametersAreNonnullByDefault
    private static final class DirectSubscriptionsCacheAccessor
    extends AbstractRelationalCacheAccessor<LikeServiceEhCacheName, ItemId, PersonId, SubscriptionModel> {
        private final LikeDAO _dao;

        private DirectSubscriptionsCacheAccessor(EhcacheClient cache, LikeDAO dao) {
            super(cache, LikeServiceEhCacheName.DIRECT_SUBSCRIPTION);
            this._dao = dao;
        }

        @Override
        protected String keyToString(ItemId left, PersonId right) {
            return left + "#" + right;
        }

        @Override
        protected Table<? extends ItemId, ? extends PersonId, ? extends SubscriptionModel> getFromDatabase(ImmutableSetMultimap<ItemId, PersonId> param) {
            return this._dao.getExplicitSubscriptions((SetMultimap<? extends ItemId, PersonId>)param);
        }
    }

    @ParametersAreNonnullByDefault
    private static final class AllLikesCacheAccessor
    extends AbstractSingleLoadingCacheAccessor<LikeServiceEhCacheName, ItemId, ImmutableSet<PersonId>> {
        private final LikeDAO _dao;

        private AllLikesCacheAccessor(EhcacheClient cache, LikeDAO dao) {
            super(cache, LikeServiceEhCacheName.ALL_LIKERS);
            this._dao = dao;
        }

        @Override
        protected ImmutableSet<PersonId> getFromDatabaseSingle(ItemId id) {
            return this._dao.getAllLikerIds(id);
        }

        @Override
        protected String keyToString(ItemId id) {
            return id.asString();
        }
    }

    @ParametersAreNonnullByDefault
    private static final class LikesCountCacheAccessor
    extends AbstractMapLoadingCacheAccessor<LikeServiceEhCacheName, ItemId, Integer> {
        private final LikeDAO _dao;

        private LikesCountCacheAccessor(EhcacheClient cache, LikeDAO dao) {
            super(cache, LikeServiceEhCacheName.LIKES_COUNT);
            this._dao = dao;
        }

        @Override
        protected Map<? extends ItemId, ? extends Integer> getFromDatabaseMulti(Set<? extends ItemId> ids) {
            return this._dao.getLikesCount(ids);
        }

        @Override
        protected String keyToString(ItemId key) {
            return key.asString();
        }
    }

    @ParametersAreNonnullByDefault
    private static final class LikesByPersonCacheAccessor
    extends AbstractSingleLoadingCacheAccessor<LikeServiceEhCacheName, PersonId, ImmutableSet<ItemId>> {
        private final LikeDAO _dao;

        private LikesByPersonCacheAccessor(EhcacheClient cache, LikeDAO dao) {
            super(cache, LikeServiceEhCacheName.LIKES_BY_PERSON);
            this._dao = dao;
        }

        @Override
        protected ImmutableSet<ItemId> getFromDatabaseSingle(PersonId id) {
            return this._dao.getLikesByPersonId(id);
        }

        @Override
        protected String keyToString(PersonId id) {
            return id.toString();
        }
    }

    @ParametersAreNonnullByDefault
    public static enum LikeServiceEhCacheName implements EhCacheName
    {
        LIKES_BY_PERSON("LikeService.likesByPerson"),
        LIKES_COUNT("LikeService.likesCount"),
        RECENT_LIKERS("LikeService.recentLikes"),
        ALL_LIKERS("LikeService.allLikes"),
        DIRECT_SUBSCRIPTION("LikeService.directSubscription"),
        SUBSCRIPTION_COUNT("LikeService.subscriptionCount");

        private final String _prefix;

        private LikeServiceEhCacheName(String prefix) {
            this._prefix = prefix;
        }

        @Override
        public String getCacheName() {
            return this._prefix;
        }
    }
}

