/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.license.business.impl;

import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.business.FileWatchService;
import de.justsoftware.onx.common.shared.server.util.ClasspathURLStreamHandler;
import de.justsoftware.onx.common.shared.server.util.Filenames;
import de.justsoftware.onx.common.shared.server.util.RegExUtilServer;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.license.business.LicenseInvalidException;
import de.justsoftware.onx.license.business.LicenseService;
import de.justsoftware.onx.license.shared.model.LicenseClientModel;
import de.justsoftware.onx.license.shared.model.LicenseInfo;
import de.justsoftware.onx.license.shared.model.LicenseProblem;
import de.justsoftware.onx.license.shared.server.model.LicenseModel;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.util.server.Base64Util;
import de.justsoftware.toolbox.clock.Clock;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Provider;
import java.security.Security;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class LicenseServiceImpl
implements LicenseService {
    private static final int CACHE_DURATION_S = 60;
    private static final String PUB_KEY = "mQENBFKKDnsBCACh5LpVhN5xay+da/l5Cr3h1jxNlNxzMjljOrBq43Du3LVP3B+rkzsmfqBmAOTVNGqJCiiW58bZQrZWzTE9w4BoTZA+xWJLXfAIe2ktXSjJCGQy0M4jpNQbfk5lTPrzWAW3V/WQEf40t8y7qpKeZ5u7AnuYHPVlUMAAMMpQQyAem7/C0BRv7W9+bG6npDHHPg9Mt6tGIY3VEC9HCxkN0fnNF5WN8UgHH2sz4DYiQhrba96QA3aOO6t4QLBpXAexTAoql1Nua2bHMLRhzZhWlFSj4o0kHQZkKrhVoPNiM1hmJb3hBxgdyjuCZbGJULdt2ZV0mxbW3jClA+MQ4PG7abHdABEBAAG0MUxpY2Vuc2UgSnVzdFNvZnR3YXJlIDxsaWNlbnNlQGp1c3Rzb2Z0d2FyZWFnLmNvbT6JATgEEwECACIFAlKKDnsCGwMGCwkIBwMCBhUIAgkKCwQWAgMBAh4BAheAAAoJEKVAuQ078Fvh5FMIAIDZyCeNo37FyJ7WTH7+ZYWKyw6N52CLo5r7tLO8MYyu0gsZVUCYAKf4itrGZuAKVsj8Yb9CbK3xYuslbGbc3hq8e1cUGo5wBiKB8KZuaIqEY7YSb8nbIuDmO2ugL21YqyqlINgTHZLfNot09vDTgtSLvuyU3tOB2CrD7x04xGlYqQhwWkcedx4qrtoijmiuuft00UWukA4L868Bwngc6grMGmm0RjCeElLrQELqxH1uwOupjMcKLC8bQLbe878aGBFh6Sz06/62EdVz+ySaFMR7TmoFePYYaNyHFXedjd7aRqUfihN6IUpCw9qEyCODkUkQpFd/TuhmdRNwXsRCrB25AQ0EUooOewEIANRDO30Cqcl2LzqJwgB/kqvp72tky5t4gYjZ0iciojJuY1hup5gOH83WcYUcx0Ca5dFMpOb2V4slJprPgA+tdcxqUtWc/5KSYrkDS2QEKeMjkNWjE7MNFFZMKtTGawA2sRUKY8vjxgt7qBVo4aegsH6NOAMMU9Y5pQNavsDU3lmDmLKohOoceaL+RHt+Dp5uqf/pWqAPbE6/SclzQdPqT1nnGypP2v9by8mUEI/P6HaGfxH0z/BDUQ0Va+/3SLL58ca/Ofr6H+4i1MKksvv0qhm5K2Q3UkkXrl/aaa9UUPpIXLpgYBTG09cZc9fIEn9+iZgvI123stZcRQI2CV4g+80AEQEAAYkBHwQYAQIACQUCUooOewIbDAAKCRClQLkNO/Bb4bCoB/0f4XVfjrRqHkuLZBlNS7qgNo2P1tQZ1tuvJjf4861o5J7Kh/oXdgXz9S91Jml7risxSYnERtB1/17mRHopNFy6L/zLHUwSSQ+/DLkdvmmeDc7KErGA+ZmrwD3lEWJwDeOpjjBQVU/g9kMjoEBAeYb4gStpjEcx8jpn25TTq1qxJ57JS+zYxL2GS8vtAg8UWqGpIL/i1i6IxRL1PyTvQoCe2ocpNsXceTMTDNAf8F3fRA4CkZf13KjE62qn32VT07XabZNX5V1uTsY8HOhP8JkIWqhPbLe2sEL1BcSEqlOkFr1N85SLBzEr7IxQLBhAXglbfVkVM6ZQaFdO/flFCBSr";
    private static final String LICENSE_FILE_NAME = "/juco.license";
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    private static final Logger LOG = LoggerFactory.getLogger(LicenseServiceImpl.class);
    private final URL _licensePath;
    private final String _domain;
    private final FileWatchService _fileWatchService;
    private final PersonService _personService;
    private final Clock _clock;
    private final Supplier<LicenseClientModel> _licenseCache = Suppliers.memoizeWithExpiration((Supplier)new Supplier<LicenseClientModel>(){

        public LicenseClientModel get() {
            return LicenseServiceImpl.this.loadLicenseClientModelImpl();
        }
    }, (long)60L, (TimeUnit)TimeUnit.SECONDS);

    @Autowired
    public LicenseServiceImpl(@Nonnull @Value(value="${domain}") String domain, @Nullable @Value(value="${license.path}") String licensePath, @Nonnull PersonService personService, @Nonnull FileWatchService fileWatchService, @Nonnull Clock clock) throws MalformedURLException {
        this(domain, StringUtils.isNotBlank((String)licensePath) ? new File(Filenames.replaceTildeByUserHome(licensePath)).toURI().toURL() : null, personService, fileWatchService, clock);
    }

    @VisibleForTesting
    LicenseServiceImpl(@Nonnull String domain, @Nullable URL licensePath, @Nonnull PersonService personService, @Nonnull FileWatchService fileWatchService, @Nonnull Clock clock) {
        this._licensePath = licensePath;
        this._domain = domain;
        this._personService = personService;
        this._fileWatchService = fileWatchService;
        this._clock = clock;
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    private byte[] loadPGPSignature(@Nonnull InputStream in, @Nonnull InputStream keyIn) throws LicenseInvalidException {
        byte[] byArray;
        InputStream decoded = null;
        InputStream literalIn = null;
        try {
            decoded = PGPUtil.getDecoderStream((InputStream)in);
            JcaKeyFingerprintCalculator fingerPrintCalculator = new JcaKeyFingerprintCalculator();
            PGPObjectFactory pgpObjectFactory = new PGPObjectFactory(decoded, (KeyFingerPrintCalculator)fingerPrintCalculator);
            PGPObjectFactory pgpFact = new PGPObjectFactory(((PGPCompressedData)pgpObjectFactory.nextObject()).getDataStream(), (KeyFingerPrintCalculator)fingerPrintCalculator);
            PGPOnePassSignatureList signatureList = (PGPOnePassSignatureList)pgpFact.nextObject();
            PGPOnePassSignature ops = signatureList.get(0);
            PGPLiteralData literalData = (PGPLiteralData)pgpFact.nextObject();
            literalIn = literalData.getInputStream();
            PGPPublicKeyRingCollection pgpRing = new PGPPublicKeyRingCollection(PGPUtil.getDecoderStream((InputStream)keyIn), (KeyFingerPrintCalculator)fingerPrintCalculator);
            PGPPublicKey key = pgpRing.getPublicKey(ops.getKeyID());
            try {
                ops.init((PGPContentVerifierBuilderProvider)new JcaPGPContentVerifierBuilderProvider().setProvider("BC"), key);
            }
            catch (NullPointerException e) {
                throw new LicenseInvalidException(e);
            }
            byte[] result = IOUtils.toByteArray((InputStream)literalIn);
            ops.update(result);
            PGPSignatureList signature = (PGPSignatureList)pgpFact.nextObject();
            if (!ops.verify(signature.get(0))) {
                throw new LicenseInvalidException("The license does not have a valid signature");
            }
            byArray = result;
        }
        catch (IOException e) {
            try {
                throw new LicenseInvalidException(e);
                catch (PGPException e2) {
                    throw new LicenseInvalidException(e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(literalIn);
                IOUtils.closeQuietly((InputStream)decoded);
                IOUtils.closeQuietly((InputStream)in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)literalIn);
        IOUtils.closeQuietly((InputStream)decoded);
        IOUtils.closeQuietly((InputStream)in);
        return byArray;
    }

    @Override
    public URL getLicenceFileURL() {
        return this._licensePath != null ? this._licensePath : LicenseServiceImpl.class.getResource(LICENSE_FILE_NAME);
    }

    @Nonnull
    private LicenseModel loadLicense() throws LicenseInvalidException {
        URL path = this.getLicenceFileURL();
        if (path == null) {
            throw new LicenseInvalidException("Could not find /juco.license");
        }
        try {
            byte[] licenseBytes = this.loadPGPSignature(path.openStream(), new ByteArrayInputStream(Base64Util.decode(PUB_KEY)));
            JSONObject license = new JSONObject(new String(licenseBytes, Charsets.UTF_8));
            String domains = license.optString("domains");
            String expiryStr = license.optString("expiry");
            int users = license.optInt("users", Integer.MAX_VALUE);
            DateTime expiry = StringUtil.isEmpty(expiryStr) ? null : DATE_FORMAT.parseDateTime(expiryStr);
            return new LicenseModel(domains, expiry, users);
        }
        catch (FileNotFoundException e) {
            throw new LicenseInvalidException(e);
        }
        catch (JSONException e) {
            throw new LicenseInvalidException(e);
        }
        catch (IllegalArgumentException e) {
            throw new LicenseInvalidException(e);
        }
        catch (IOException e) {
            throw new LicenseInvalidException(e);
        }
    }

    @Nonnull
    private ImmutableSet<LicenseProblem> checkLicense(@Nullable LicenseModel license) {
        int activeUserCount;
        int users;
        if (license == null) {
            return ImmutableSet.of((Object)((Object)LicenseProblem.COULD_NOT_LOAD_OR_VERIFY));
        }
        ImmutableSet.Builder problems = ImmutableSet.builder();
        DateTime expiry = license.getExpiry();
        if (expiry != null && expiry.isBefore((ReadableInstant)this._clock.now())) {
            problems.add((Object)LicenseProblem.EXPIRED);
        }
        if ((users = license.getUsers()) < Integer.MAX_VALUE && (activeUserCount = this._personService.getActiveUserCount()) > users) {
            problems.add((Object)LicenseProblem.TOO_MANY_USERS);
        }
        if (!RegExUtilServer.wildcardsListToRegEx(license.getDomains()).matcher(this._domain).matches()) {
            problems.add((Object)LicenseProblem.NO_DOMAIN_MATCH);
        }
        return problems.build();
    }

    private LicenseClientModel loadLicenseClientModelImpl() {
        try {
            LicenseModel license = this.loadLicense();
            return new LicenseClientModel(this.checkLicense(license), license.getDomains());
        }
        catch (LicenseInvalidException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return new LicenseClientModel(this.checkLicense(null), null);
        }
    }

    @Override
    public LicenseClientModel loadLicenseClientModel() {
        return (LicenseClientModel)this._licenseCache.get();
    }

    @Override
    public LicenseInfo getLicenseInfo() {
        int usedUsersLicense = this._personService.getActiveUserCount();
        try {
            LicenseModel license = this.loadLicense();
            DateTime expiry = license.getExpiry();
            return new LicenseInfo(license.getDomains(), expiry != null ? DateWithoutTimezone.clone(expiry.toDate()) : null, license.getUsers(), usedUsersLicense);
        }
        catch (LicenseInvalidException e) {
            return new LicenseInfo(null, null, 0, usedUsersLicense);
        }
    }

    @PostConstruct
    public void registerLicenseFileWatch() throws MalformedURLException {
        URL licenceFileURL = this.getLicenceFileURL();
        if (licenceFileURL == null) {
            licenceFileURL = new URL(null, "classpath:/juco.license", new ClasspathURLStreamHandler());
        }
        this._fileWatchService.registerWatchesFiles((List<URL>)ImmutableList.of((Object)licenceFileURL), FileWatchService.FileChangeEvent.LICENSE_FILE_CHANGED);
    }
}

