/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.kafka.metrics;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.kafka.metrics.LagMetrics;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;

@ParametersAreNonnullByDefault
public class ConsumerMetrics {
    private final ImmutableSet<MetricName> _keySet;
    private final ImmutableMap<MetricName, ? extends Metric> _metrics;

    public ConsumerMetrics(Map<MetricName, ? extends Metric> metrics) {
        this._metrics = ImmutableMap.copyOf(metrics);
        this._keySet = this._metrics.keySet();
    }

    @Nonnull
    public LagMetrics getLagMetrics() {
        Double avgLag = this.unwrapOptional(this.findByName("records-lag-avg"));
        Double currentLag = this.unwrapOptional(this.findByName("records-lag"));
        Double maxLag = this.unwrapOptional(this.findByName("records-lag-max"));
        return new LagMetrics(currentLag, avgLag, maxLag);
    }

    public String toString() {
        return this._metrics.entrySet().stream().map(entry -> ((MetricName)entry.getKey()).name() + ": " + ((Metric)entry.getValue()).metricValue().toString()).collect(Collectors.joining(",\n"));
    }

    @Nonnull
    private Double unwrapOptional(Optional<Metric> metric) {
        return metric.map(it -> (Double)it.metricValue()).orElse(Double.NaN);
    }

    @Nonnull
    private Optional<Metric> findByName(String name) {
        Optional<MetricName> key = this._keySet.stream().filter(metricName -> name.equals(metricName.name())).findFirst();
        return key.map(arg_0 -> this._metrics.get(arg_0));
    }
}

