/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.kafka.impl;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.admin.NewTopic;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
@ParametersAreNonnullByDefault
@Profile(value={"!integration-test"})
public class KafkaTopicConfiguration {
    public static final String MIGRATION_ITEM_TOPIC = "just.migration.item";
    public static final String SEARCH_LTR_TRACKING_TOPIC = "just.search.ltr.tracking";
    private static final String SEVEN_DAYS_IN_MS = "604800000";
    private static final ImmutableMap<String, String> DEFAULT_TOPIC_CONFIG = ImmutableMap.of((Object)"delete.retention.ms", (Object)"604800000", (Object)"segment.ms", (Object)"604800000", (Object)"cleanup.policy", (Object)"compact");

    @Nonnull
    private static NewTopic topicFactory(String topicName) {
        return KafkaTopicConfiguration.topicFactory(topicName, 1);
    }

    @Nonnull
    private static NewTopic topicFactory(String topicName, int partitions) {
        NewTopic topic = new NewTopic(topicName, partitions, 1);
        return topic.configs(DEFAULT_TOPIC_CONFIG);
    }

    @Nonnull
    @Bean
    public NewTopic tenantsTopic() {
        return KafkaTopicConfiguration.topicFactory("just.tenants");
    }

    @Nonnull
    @Bean
    public NewTopic tenantsMigrationTopic() {
        return KafkaTopicConfiguration.topicFactory("just.toro.migration.tenants");
    }

    @Nonnull
    @Bean
    public NewTopic newsMigrationTopic() {
        NewTopic newsMigrationTopic = new NewTopic("just.toro.migration.news", 1, 1);
        ImmutableMap config = ImmutableMap.of((Object)"max.message.bytes", (Object)"20971520");
        return newsMigrationTopic.configs((Map)config);
    }

    @Nonnull
    @Bean
    public NewTopic taskAssignmentTopic() {
        return KafkaTopicConfiguration.topicFactory("just.tasks.assignments");
    }

    @Nonnull
    @Bean
    public NewTopic taskCompletionsTopic() {
        return KafkaTopicConfiguration.topicFactory("just.tasks.completions");
    }

    @Nonnull
    @Bean
    public NewTopic taskListsTopic() {
        return KafkaTopicConfiguration.topicFactory("just.tasks.lists");
    }

    @Nonnull
    @Bean
    public NewTopic personsTopic() {
        return KafkaTopicConfiguration.topicFactory("just.persons");
    }

    @Nonnull
    @Bean
    public NewTopic personsExternalIdTopic() {
        return KafkaTopicConfiguration.topicFactory("just.persons.externalId");
    }

    @Nonnull
    @Bean
    public NewTopic personsProfileAttributesTopic() {
        return KafkaTopicConfiguration.topicFactory("just.persons.profileAttributes");
    }

    @Nonnull
    @Bean
    public NewTopic personsProfileAttributesConfigTopic() {
        return KafkaTopicConfiguration.topicFactory("just.persons.profileAttributesConfig");
    }

    @Nonnull
    @Bean
    public NewTopic personsTenantIdsTopic() {
        return KafkaTopicConfiguration.topicFactory("just.persons.tenantIds");
    }

    @Nonnull
    @Bean
    public NewTopic itemActionsTopic() {
        return KafkaTopicConfiguration.topicFactory("just.item.actions");
    }

    @Nonnull
    @Bean
    public NewTopic itemsTopic() {
        return KafkaTopicConfiguration.topicFactory("just.items");
    }

    @Nonnull
    @Bean
    public NewTopic searchIndexParentsTopic() {
        return KafkaTopicConfiguration.topicFactory("just.search.index.parents");
    }

    @Nonnull
    @Bean
    public NewTopic searchIndexSubscribersTopic() {
        return KafkaTopicConfiguration.topicFactory("just.search.index.subscribers");
    }

    @Nonnull
    @Bean
    public NewTopic searchIndexVisibilitiesTopic() {
        return KafkaTopicConfiguration.topicFactory("just.search.index.visibilities");
    }

    @Nonnull
    @Bean
    public NewTopic migrationDocumentsTopic() {
        return KafkaTopicConfiguration.topicFactory("just.migration.documents");
    }

    @Nonnull
    @Bean
    public NewTopic trackingTopic() {
        NewTopic topic = new NewTopic("tracking", 1, 1);
        ImmutableMap config = ImmutableMap.of((Object)"retention.ms", (Object)"-1", (Object)"retention.bytes", (Object)"2147483648", (Object)"segment.bytes", (Object)"209715200");
        return topic.configs((Map)config);
    }

    @Nonnull
    @Bean
    public NewTopic notificationPushTopic() {
        NewTopic topic = new NewTopic("just.notification.push", 5, 1);
        ImmutableMap config = ImmutableMap.of((Object)"delete.retention.ms", (Object)SEVEN_DAYS_IN_MS, (Object)"segment.ms", (Object)SEVEN_DAYS_IN_MS, (Object)"cleanup.policy", (Object)"delete");
        return topic.configs((Map)config);
    }

    @Nonnull
    @Bean
    public NewTopic entityAnchorTopic() {
        return new NewTopic("just.entity.anchor", 1, 1);
    }

    @Nonnull
    @Bean
    public NewTopic changeVersionTopic() {
        return new NewTopic("just.change.version", 1, 1);
    }

    @Nonnull
    @Bean
    public NewTopic rolesTopic() {
        return new NewTopic("just.roles", 1, 1);
    }

    @Nonnull
    @Bean
    public NewTopic memberRoleUpdatesTopic() {
        return KafkaTopicConfiguration.topicFactory("just.export.memberRoleUpdates").configs(this.configForJustExportTopics());
    }

    @Nonnull
    @Bean
    public NewTopic memberGroupUpdatesTopic() {
        return KafkaTopicConfiguration.topicFactory("just.export.memberGroupUpdates").configs(this.configForJustExportTopics());
    }

    @Nonnull
    @Bean
    public NewTopic migrationItemTopic() {
        return KafkaTopicConfiguration.topicFactory(MIGRATION_ITEM_TOPIC).configs((Map)ImmutableMap.of((Object)"delete.retention.ms", (Object)SEVEN_DAYS_IN_MS, (Object)"segment.ms", (Object)SEVEN_DAYS_IN_MS, (Object)"cleanup.policy", (Object)"delete"));
    }

    @Nonnull
    private Map<String, String> configForJustExportTopics() {
        String oneMonthInMs = String.valueOf(Long.parseLong(SEVEN_DAYS_IN_MS) * 4L);
        return ImmutableMap.of((Object)"delete.retention.ms", (Object)oneMonthInMs, (Object)"segment.ms", (Object)oneMonthInMs, (Object)"cleanup.policy", (Object)"delete");
    }
}

