/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.kafka.impl;

import com.google.common.base.MoreObjects;
import de.justsoftware.onx.kafka.KafkaConfigurationProvider;
import java.util.Properties;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.StringUtils;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class KafkaConfigurationProviderImpl
implements KafkaConfigurationProvider {
    private final String _bootstrapServers;
    private final int _maxChunkSize;

    @Autowired
    public KafkaConfigurationProviderImpl(@Nullable @Value(value="${kafka.bootstrapServers:}") String bootstrapServers, @Value(value="${kafka.consumerMaxChunkSize:100}") int maxChunkSize) {
        this._bootstrapServers = bootstrapServers;
        this._maxChunkSize = maxChunkSize;
    }

    @Override
    public Properties consumerConfig(String groupid) {
        return this.consumerConfig(groupid, this._maxChunkSize, null);
    }

    @CheckForNull
    private Properties consumerConfig(String groupid, int maxChunkSize, @Nullable String autoResetOffsetStrategy) {
        Properties props = this.manualConsumerConfig(maxChunkSize, autoResetOffsetStrategy);
        if (props != null) {
            props.put("group.id", groupid);
        }
        return props;
    }

    @Override
    public Properties manualConsumerConfig() {
        return this.manualConsumerConfig(this._maxChunkSize, null);
    }

    @CheckForNull
    private Properties manualConsumerConfig(int maxChunkSize, @Nullable String autoResetOffsetStrategy) {
        if (StringUtils.isBlank((String)this._bootstrapServers)) {
            return null;
        }
        Properties props = new Properties();
        props.put("bootstrap.servers", this._bootstrapServers);
        props.put("enable.auto.commit", "false");
        props.put("auto.offset.reset", MoreObjects.firstNonNull((Object)autoResetOffsetStrategy, (Object)"earliest"));
        props.put("max.poll.records", (Object)Math.min(maxChunkSize, this._maxChunkSize));
        return props;
    }

    @Override
    public Properties producerConfig() {
        if (StringUtils.isBlank((String)this._bootstrapServers)) {
            return null;
        }
        Properties props = new Properties();
        props.put("bootstrap.servers", this._bootstrapServers);
        props.put("acks", "all");
        props.put("retries", (Object)0);
        props.put("batch.size", (Object)16384);
        props.put("linger.ms", (Object)1);
        props.put("buffer.memory", (Object)0x2000000);
        return props;
    }

    @Override
    public Consumer<String, String> stringConsumer(String groupId) {
        return this.stringConsumer(groupId, this._maxChunkSize);
    }

    @Override
    public Consumer<String, String> stringConsumer(String groupId, int maxChunkSize, String autoResetOffsetStrategy) {
        return this.consumer(groupId, (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer(), maxChunkSize, autoResetOffsetStrategy);
    }

    @Override
    public Consumer<String, String> stringConsumer(String groupId, int maxChunkSize) {
        return this.consumer(groupId, (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer(), maxChunkSize, null);
    }

    @Override
    public <K, V> Consumer<K, V> consumer(String groupId, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        return this.consumer(groupId, keyDeserializer, valueDeserializer, this._maxChunkSize, null);
    }

    @CheckForNull
    private <K, V> Consumer<K, V> consumer(String groupId, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer, int maxChunkSize, @Nullable String autoResetOffsetStrategy) {
        Properties config = this.consumerConfig(groupId, maxChunkSize, autoResetOffsetStrategy);
        if (config == null) {
            return null;
        }
        return new KafkaConsumer(config, keyDeserializer, valueDeserializer);
    }
}

