/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.kafka.impl;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import de.justsoftware.kafka.client.KafkaCleaningProducer;
import de.justsoftware.kafka.client.KafkaCleaningProducerImpl;
import de.justsoftware.onx.kafka.KafkaConfigurationProvider;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.kafka.core.KafkaAdmin;

@Configuration
@ParametersAreNonnullByDefault
public class KafkaConfiguration {
    public static final String KAFKA_STRING_PRODUCER = "KAFKA_STRING_PRODUCER";
    public static final String KAFKA_LARGE_STRING_PRODUCER = "KAFKA_LARGE_STRING_PRODUCER";
    public static final String MAX_MESSAGE_SIZE_20_MB = "20971520";
    @Autowired
    private KafkaConfigurationProvider _kafkaConfigProvider;
    @Value(value="${kafka.bootstrapServers:}")
    private String _bootstrapServersUrl;

    @Bean(name={"KAFKA_STRING_PRODUCER"}, destroyMethod="close")
    @Primary
    @CheckForNull
    public KafkaCleaningProducer<String, String> createStringProducer() {
        Properties props = this._kafkaConfigProvider.producerConfig();
        if (props == null) {
            return null;
        }
        KafkaProducer<String, String> delegate = new KafkaProducer<String, String>(props, (Serializer)new StringSerializer(), (Serializer)new StringSerializer()){

            public void close() {
                super.close(1L, TimeUnit.MINUTES);
            }
        };
        return new KafkaCleaningProducerImpl((Producer)delegate, this::createCleaningConsumer);
    }

    @Bean(name={"KAFKA_LARGE_STRING_PRODUCER"}, destroyMethod="close")
    @CheckForNull
    public KafkaCleaningProducer<String, String> createLargeStringProducer() {
        Properties props = this._kafkaConfigProvider.producerConfig();
        if (props == null) {
            return null;
        }
        props.setProperty("max.request.size", MAX_MESSAGE_SIZE_20_MB);
        KafkaProducer<String, String> delegate = new KafkaProducer<String, String>(props, (Serializer)new StringSerializer(), (Serializer)new StringSerializer()){

            public void close() {
                super.close(1L, TimeUnit.MINUTES);
            }
        };
        return new KafkaCleaningProducerImpl((Producer)delegate, this::createCleaningConsumer);
    }

    @Nonnull
    private Consumer<String, ?> createCleaningConsumer(TopicPartition tp) {
        return KafkaCleaningProducerImpl.createStringConsumer((TopicPartition)tp, (Properties)this._kafkaConfigProvider.manualConsumerConfig());
    }

    @CheckForNull
    @Bean
    public KafkaAdmin admin(@Nullable @Value(value="${kafka.bootstrapServers:}") String bootstrapServer) {
        if (Strings.isNullOrEmpty((String)bootstrapServer)) {
            return null;
        }
        ImmutableMap configs = ImmutableMap.of((Object)"bootstrap.servers", (Object)bootstrapServer);
        KafkaAdmin kafkaAdmin = new KafkaAdmin((Map)configs);
        kafkaAdmin.setFatalIfBrokerNotAvailable(true);
        return kafkaAdmin;
    }
}

