/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.integration.integration.persistence.ibatis;

import com.freiheit.toro.common.integration.persistence.ibatis.IbatisDAOUtil;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.ibatis.sqlmap.client.SqlMapClient;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.integration.integration.persistence.ExternalIdentificationDAO;
import de.justsoftware.onx.integration.shared.model.DBExternalIdentification;
import de.justsoftware.onx.integration.shared.model.ExternalPersonId;
import de.justsoftware.onx.integration.shared.model.ExternalSystemId;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class IbatisExternalIdentificationDAO
implements ExternalIdentificationDAO {
    private static final String NAMESPACE = "ExternalIdentification.";
    @Autowired
    @Qualifier(value="sqlMapClient")
    private SqlMapClient _sqlMapper;

    @Override
    public PersonId getPersonId(ExternalPersonId externalPersonId, ExternalSystemId systemId) {
        return (PersonId)IbatisDAOUtil.wrappedQueryForObject(this._sqlMapper, "ExternalIdentification.getPersonId", ImmutableMap.of((Object)"externalId", (Object)externalPersonId, (Object)"systemId", (Object)systemId));
    }

    @Override
    public ExternalPersonId getExternalPersonId(PersonId personId, ExternalSystemId systemId) {
        return (ExternalPersonId)IbatisDAOUtil.wrappedQueryForObject(this._sqlMapper, "ExternalIdentification.getExternalPersonId", ImmutableMap.of((Object)"personId", (Object)personId, (Object)"systemId", (Object)systemId));
    }

    @Override
    public Map<PersonId, ExternalPersonId> getExternalPersonIds(List<PersonId> personIds, ExternalSystemId systemId) {
        if (personIds.isEmpty()) {
            return Collections.emptyMap();
        }
        return IbatisDAOUtil.wrappedPartitionQueryForMap(this._sqlMapper, "ExternalIdentification.getExternalPersonIds", "personId", "externalPersonId", ImmutableSet.copyOf(personIds), IbatisDAOUtil.createParameterFunctionForIdsWithMapData("personIds", ImmutableMap.of((Object)"systemId", (Object)systemId)));
    }

    @Override
    public void insertExternalIdentification(PersonId personId, ExternalPersonId externalPersonId, ExternalSystemId systemId) {
        IbatisDAOUtil.wrappedInsert(this._sqlMapper, "ExternalIdentification.insertExternalIdentification", new DBExternalIdentification(personId, externalPersonId, systemId));
    }

    @Override
    public void removeExternalIdentification(PersonId personId, ExternalSystemId systemId) {
        IbatisDAOUtil.wrappedDelete(this._sqlMapper, "ExternalIdentification.deleteExternalIdentification", ImmutableMap.of((Object)"personId", (Object)personId, (Object)"systemId", (Object)systemId));
    }
}

