/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.integration.business.impl;

import com.freiheit.toro.cache.ehcache.EhCacheName;
import com.freiheit.toro.cache.ehcache.EhcacheClient;
import de.justsoftware.onx.common.cache.AbstractSingleLoadingCacheAccessor;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.integration.business.PersonExternalIdReadWriteDataService;
import de.justsoftware.onx.integration.integration.persistence.ExternalIdentificationDAO;
import de.justsoftware.onx.integration.shared.model.ExternalPersonId;
import de.justsoftware.onx.integration.shared.model.ExternalSystemId;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PersonExternalIdReadWriteDataServiceImpl
implements PersonExternalIdReadWriteDataService {
    private final ExternalIdentificationDAO _externalIdentificationDAO;
    private final ExternalIdentificationCacheAccessor _cacheAccessor;

    @Autowired
    @ParametersAreNonnullByDefault
    public PersonExternalIdReadWriteDataServiceImpl(ExternalIdentificationDAO externalIdentificationDAO, EhcacheClient ehcacheClient) {
        this._externalIdentificationDAO = externalIdentificationDAO;
        this._cacheAccessor = new ExternalIdentificationCacheAccessor(ehcacheClient, externalIdentificationDAO);
    }

    @Override
    public PersonId getPersonId(ExternalPersonId externalPersonId, ExternalSystemId systemId) {
        return this._externalIdentificationDAO.getPersonId(externalPersonId, systemId);
    }

    @Override
    public ExternalPersonId getExternalPersonId(PersonId personId, ExternalSystemId systemId) {
        return (ExternalPersonId)this._cacheAccessor.getSingle(new PersonIdWithExternalSystem(personId, systemId));
    }

    @Override
    public Map<PersonId, ExternalPersonId> getExternalPersonIds(List<PersonId> personIds, ExternalSystemId systemId) {
        return this._externalIdentificationDAO.getExternalPersonIds(personIds, systemId);
    }

    @Override
    public void insertExternalIdentification(PersonId personId, ExternalPersonId externalPersonId, ExternalSystemId systemId) {
        this._externalIdentificationDAO.insertExternalIdentification(personId, externalPersonId, systemId);
        this._cacheAccessor.invalidateKeyAndWait(new PersonIdWithExternalSystem(personId, systemId));
    }

    @Override
    public void removeExternalIdentification(PersonId personId, ExternalSystemId systemId) {
        this._externalIdentificationDAO.removeExternalIdentification(personId, systemId);
        this._cacheAccessor.invalidateKeyAndWait(new PersonIdWithExternalSystem(personId, systemId));
    }

    private static class ExternalIdentificationCacheAccessor
    extends AbstractSingleLoadingCacheAccessor<PersonExternalIdServiceEhCacheName, PersonIdWithExternalSystem, ExternalPersonId> {
        private final ExternalIdentificationDAO _externalIdentificationDAO;

        ExternalIdentificationCacheAccessor(@Nonnull EhcacheClient cache, @Nonnull ExternalIdentificationDAO externalIdentificationDAO) {
            super(cache, PersonExternalIdServiceEhCacheName.EXTERNAL_ID);
            this._externalIdentificationDAO = externalIdentificationDAO;
        }

        @Override
        protected String keyToString(PersonIdWithExternalSystem input) {
            return input.toString();
        }

        @Override
        protected ExternalPersonId getFromDatabaseSingle(PersonIdWithExternalSystem input) {
            return this._externalIdentificationDAO.getExternalPersonId(input._personId, input._externalSystemId);
        }
    }

    public static enum PersonExternalIdServiceEhCacheName implements EhCacheName
    {
        EXTERNAL_ID("PersonExternalIdService.externalId");

        private final String _cacheName;

        private PersonExternalIdServiceEhCacheName(String cacheName) {
            this._cacheName = cacheName;
        }

        @Override
        public String getCacheName() {
            return this._cacheName;
        }
    }

    private static final class PersonIdWithExternalSystem {
        private final PersonId _personId;
        private final ExternalSystemId _externalSystemId;

        private PersonIdWithExternalSystem(@Nonnull PersonId personId, @Nonnull ExternalSystemId externalSystemId) {
            this._externalSystemId = externalSystemId;
            this._personId = personId;
        }
    }
}

