/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.impersonation.impl;

import com.freiheit.toro.common.shared.model.PermissionDeniedException;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.NotFound;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.impersonation.ImpersonationService;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.security.SecurityUtils;
import de.justsoftware.onx.security.jwt.JwtConfigurationException;
import de.justsoftware.onx.security.jwt.JwtService;
import de.justsoftware.onx.security.model.JustConnectUser;
import de.justsoftware.onx.tenant.business.PersonTenantService;
import de.justsoftware.onx.tenant.integration.persistence.model.Tenant;
import de.justsoftware.permission.client.model.AuthorizationResult;
import de.justsoftware.permission.client.model.Role;
import de.justsoftware.permission.client.rest.PermissionRequestConnector;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsChecker;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class ImpersonationServiceImpl
implements ImpersonationService {
    public static final int IMPERSONATING_SESSION_LIFETIME_MINUTES = 10;
    public static final Set<Role> FORBIDDEN_ROLES = Set.of(Role.SUPERADMIN, Role.create((String)"BACKENDADMIN"));
    private final PersonService _personService;
    private final PersonTenantService _personTenantService;
    private final JwtService _jwtService;
    private final UserDetailsChecker _userValidator;
    private final PermissionRequestConnector _permissionRequestConnector;

    public ImpersonationServiceImpl(PersonService personService, PersonTenantService personTenantService, JwtService jwtService, UserDetailsChecker userValidator, PermissionRequestConnector permissionRequestConnector) {
        this._personService = personService;
        this._personTenantService = personTenantService;
        this._jwtService = jwtService;
        this._userValidator = userValidator;
        this._permissionRequestConnector = permissionRequestConnector;
    }

    @Override
    public String becomeUser(AuthorizationCheckContext authCtx, PersonId personId) {
        authCtx.check(StaticAction.BECOME_USER);
        DBPerson targetPerson = this._personService.getPersonById(personId);
        if (targetPerson == null) {
            throw new NotFound(Set.of(Role.profileRole((long)personId.getId())));
        }
        JustConnectUser userDetails = SecurityUtils.getJustConnectUser(targetPerson);
        try {
            this._userValidator.check((UserDetails)userDetails);
            this.checkForbiddenRoles(targetPerson.getId());
        }
        catch (PermissionDeniedException | AuthenticationException e) {
            throw new PermissionDeniedException("User is not allowed to be impersonated.");
        }
        ImmutableSet<Tenant> personTenants = this._personTenantService.getPersonTenants(targetPerson.getId());
        if (personTenants.size() != 1) {
            throw new PermissionDeniedException("User can not be impersonated due to not belonging to exactly one tenant.");
        }
        Tenant personTenant = (Tenant)personTenants.stream().findFirst().get();
        try {
            return this._jwtService.createLoginJWT(targetPerson.getId(), personTenant.getId(), 10);
        }
        catch (JwtConfigurationException e) {
            throw new ServiceException("Could not create JWT for user " + personId);
        }
    }

    private void checkForbiddenRoles(PersonId personId) {
        Set<Role> targetPermissionRole = Set.of(Role.profileRole((long)personId.getId()));
        ImmutableMap targetRoleMappings = this._permissionRequestConnector.hasRoles(FORBIDDEN_ROLES, targetPermissionRole);
        boolean hasForbiddenRole = targetRoleMappings.values().stream().anyMatch(it -> it == AuthorizationResult.OK);
        if (hasForbiddenRole) {
            throw new PermissionDeniedException("User is admin and can't be impersonated");
        }
    }
}

