/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.hierarchy.business.impl;

import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.justsoftware.onx.authorization.business.SearchAuthorizationCheckContext;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.StaticEntityAction;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.common.shared.util.Numbers;
import de.justsoftware.onx.container.business.EntityChildrenService;
import de.justsoftware.onx.container.business.EntityMemberService;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.EntityMember;
import de.justsoftware.onx.container.shared.model.EntityMemberWithEntityType;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.model.db.DBEntityLink;
import de.justsoftware.onx.container.shared.model.util.EntityMemberUtil;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.hierarchy.business.HierarchyService;
import de.justsoftware.onx.hierarchy.shared.model.EntityTreeData;
import de.justsoftware.onx.hierarchy.shared.model.EntityTreeItemData;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HierarchyServiceImpl
implements HierarchyService {
    private final EntityService _entityService;
    private final EntityMemberService _entityMemberService;
    private final EntityChildrenService _entityChildrenService;

    @Autowired
    @ParametersAreNonnullByDefault
    public HierarchyServiceImpl(EntityService entityService, EntityMemberService entityMemberService, EntityChildrenService entityChildrenService) {
        this._entityService = entityService;
        this._entityMemberService = entityMemberService;
        this._entityChildrenService = entityChildrenService;
    }

    @Override
    public ImmutableList<EntityTreeItemData> getDirectChildEntityTree(EntityId parentId, ImmutableSet<EntityType> typesForTree, SearchAuthorizationCheckContext authCtx) throws ServiceException {
        DBEntity entity = this._entityService.getById(parentId);
        if (entity == null) {
            return ImmutableList.of();
        }
        ImmutableSet childEntityIds = ImmutableSet.copyOf(this._entityChildrenService.getVisibleChildrenIds(authCtx, parentId, (Iterable<EntityType>)typesForTree, 0, Integer.MAX_VALUE, null, null));
        if (CollectionUtil.isEmpty(childEntityIds)) {
            return ImmutableList.of();
        }
        Map<EntityId, EntityMemberWithEntityType> members = this._entityMemberService.getMemberByPersonIdAndEntityIds(authCtx.getUserId(), (Set<EntityId>)childEntityIds);
        ImmutableMap<EntityId, Long> childCount = this._entityChildrenService.getVisibleChildrenCountsMappedByEntityId(authCtx, (Set<EntityType>)typesForTree, (Set<EntityId>)childEntityIds, true);
        ImmutableMap<EntityId, EntityInfo> entityInfos = this._entityService.getInfoMapByIds((Set<EntityId>)childEntityIds, authCtx);
        ImmutableList.Builder result = ImmutableList.builder();
        for (Map.Entry child : entityInfos.entrySet()) {
            EntityId childEntityId = (EntityId)child.getKey();
            EntityMember member = members.get(childEntityId);
            int count = Numbers.intValue((Number)childCount.get(childEntityId));
            EntityInfo teaser = (EntityInfo)child.getValue();
            boolean isMember = member != null && EntityMemberUtil.isMember(member);
            boolean isAdminOrCoAdmin = member != null && EntityMemberUtil.isAdminOrCoAdmin(member);
            result.add((Object)new EntityTreeItemData(teaser, isMember, isAdminOrCoAdmin, count));
        }
        return result.build();
    }

    @Override
    public ImmutableList<EntityTreeItemData> getEntityTreeWithParentNodeByEntityId(EntityId id, final ImmutableSet<EntityType> entityTypes, SearchAuthorizationCheckContext authorizationContext) throws ServiceException {
        if (CollectionUtils.isEmpty(entityTypes)) {
            return ImmutableList.of();
        }
        DBEntity entity = this._entityService.getById(id);
        if (entity == null || !entityTypes.contains((Object)entity.getType())) {
            return ImmutableList.of();
        }
        Iterator<DBEntity> parents = this._entityService.searchParents(Lists.newArrayList((Object[])new EntityId[]{id}), new EntityService.SearchPredicates(){

            @Override
            public boolean isResult(DBEntity e, int depth, EntityId childBefore) {
                return entityTypes.contains((Object)e.getType());
            }

            @Override
            public boolean expand(DBEntity e, int depth, EntityId childBefore) {
                return entityTypes.contains((Object)e.getType());
            }
        });
        HashMap entities = Maps.newHashMap();
        entities.put(entity.getId(), entity);
        while (parents.hasNext()) {
            DBEntity next = parents.next();
            entities.put(next.getId(), next);
        }
        return this.getEntityTreeItemData(entities, (Set<EntityType>)entityTypes, authorizationContext, new NoParentIsRootPredicate(entities));
    }

    @Nonnull
    private ImmutableList<EntityTreeItemData> getEntityTreeItemData(@Nonnull Map<EntityId, DBEntity> entities, @Nonnull Set<EntityType> types, @Nonnull SearchAuthorizationCheckContext authorizationContext, @Nonnull Predicate<DBEntity> isRoot) {
        PersonId userId = authorizationContext.getUserId();
        Map<EntityId, EntityMemberWithEntityType> members = this._entityMemberService.getMemberByPersonIdAndEntityIds(userId, entities.keySet());
        ImmutableMap<EntityId, Long> childCount = this._entityChildrenService.getVisibleChildrenCountsMappedByEntityId(authorizationContext, types, entities.keySet(), true);
        ImmutableMap<EntityId, EntityInfo> entityInfos = this._entityService.createInfos(entities.values(), authorizationContext);
        ImmutableList.Builder result = ImmutableList.builder();
        HashMap<EntityId, EntityTreeItemData> treeItems = new HashMap<EntityId, EntityTreeItemData>();
        for (DBEntity e : entities.values()) {
            EntityTreeItemData i = this.addToTree(e, entities, (Map<EntityId, EntityInfo>)entityInfos, (Map<EntityId, ? extends EntityMember>)members, (Map<EntityId, Long>)childCount, (Map<EntityId, EntityTreeItemData>)treeItems);
            if (!isRoot.apply((Object)e)) continue;
            result.add((Object)i);
        }
        return result.build();
    }

    @Nonnull
    private Map<EntityId, DBEntity> getLinkedEntitiesRecursive(@Nonnull Map<EntityId, DBEntity> entities) {
        HashSet linkedEntityIds = Sets.newHashSet();
        for (DBEntity e : entities.values()) {
            for (DBEntityLink link : e.getLinkedEntities()) {
                linkedEntityIds.add(link.getLinkedEntityId());
            }
        }
        HashMap linkedEntities = Maps.newHashMap();
        Sets.SetView missingLinkedEntityIds = Sets.difference((Set)linkedEntityIds, (Set)Sets.union(entities.keySet(), linkedEntities.keySet()));
        while (!missingLinkedEntityIds.isEmpty()) {
            Map<EntityId, DBEntity> load = this._entityService.getByIds((Set<EntityId>)missingLinkedEntityIds);
            linkedEntities.putAll(load);
        }
        return linkedEntities;
    }

    @Nonnull
    private EntityTreeItemData addToTree(@Nonnull DBEntity entity, @Nonnull Map<EntityId, DBEntity> entities, @Nonnull Map<EntityId, EntityInfo> entityInfos, @Nonnull Map<EntityId, ? extends EntityMember> members, @Nonnull Map<EntityId, Long> childCount, @Nonnull Map<EntityId, EntityTreeItemData> tree) {
        EntityId entityId = entity.getId();
        EntityTreeItemData existingTreeItem = tree.get(entityId);
        if (existingTreeItem != null) {
            return existingTreeItem;
        }
        EntityMember member = members.get(entityId);
        boolean isAdmin = member != null && EntityMemberUtil.isAdminOrCoAdmin(member);
        boolean isMember = member != null && EntityMemberUtil.isShownAsMember(member);
        int count = Numbers.intValue(childCount.get(entityId));
        EntityInfo entityInfo = (EntityInfo)Preconditions.checkNotNull((Object)entityInfos.get(entityId));
        EntityTreeItemData treeItem = new EntityTreeItemData(entityInfo, isMember, isAdmin, count);
        tree.put(entityId, treeItem);
        for (DBEntityLink link : entity.getLinkedEntities()) {
            DBEntity parentEntity = entities.get(link.getLinkedEntityId());
            if (parentEntity == null) continue;
            EntityTreeItemData parent = this.addToTree(parentEntity, entities, entityInfos, members, childCount, tree);
            parent.addChild(treeItem);
        }
        return treeItem;
    }

    @Override
    public EntityTreeData getChildTree(EntityId parentEntityId, ImmutableSet<EntityType> entityTypes, SearchAuthorizationCheckContext authorizationContext) {
        Map<EntityId, DBEntity> directChildEntities = this._entityService.getByIds((Set<EntityId>)this._entityService.getDirectChildEntityIds(parentEntityId));
        HashMap entities = Maps.newHashMap();
        LinkedList entityItems = Lists.newLinkedList();
        for (DBEntity dBEntity : directChildEntities.values()) {
            if (!entityTypes.contains((Object)dBEntity.getType())) continue;
            entityItems.add(new EntityItem(dBEntity));
        }
        Iterable visible = authorizationContext.filterAllowedItems(entityItems, StaticEntityAction.ENTITY_READ_DETAILS);
        for (EntityItem child : visible) {
            entities.put(child.getId(), child.getEntity());
        }
        ImmutableList<EntityTreeItemData> immutableList = this.getEntityTreeItemData(entities, (Set<EntityType>)entityTypes, authorizationContext, new EntityIsChildOfIsRootPredicate(parentEntityId));
        return new EntityTreeData(immutableList, entityTypes, (ImmutableSet<EntityId>)ImmutableSet.of());
    }

    private static final class NoParentIsRootPredicate
    implements Predicate<DBEntity> {
        private final Map<EntityId, DBEntity> _entities;

        private NoParentIsRootPredicate(@Nonnull Map<EntityId, DBEntity> entities) {
            this._entities = entities;
        }

        public boolean apply(DBEntity input) {
            if (input == null) {
                return false;
            }
            List<DBEntityLink> linkedEntities = input.getLinkedEntities();
            if (CollectionUtils.isEmpty(linkedEntities)) {
                return true;
            }
            for (DBEntityLink link : linkedEntities) {
                if (this._entities.get(link.getLinkedEntityId()) == null) continue;
                return false;
            }
            return true;
        }
    }

    private static final class EntityIsChildOfIsRootPredicate
    implements Predicate<DBEntity> {
        private final EntityId _entityId;

        private EntityIsChildOfIsRootPredicate(@Nonnull EntityId entityId) {
            this._entityId = entityId;
        }

        public boolean apply(DBEntity input) {
            if (input == null) {
                return false;
            }
            List<DBEntityLink> linkedEntities = input.getLinkedEntities();
            if (CollectionUtils.isEmpty(linkedEntities)) {
                return false;
            }
            for (DBEntityLink link : linkedEntities) {
                if (!this._entityId.equals(link.getLinkedEntityId())) continue;
                return true;
            }
            return false;
        }
    }
}

