/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.extensions.business.impl;

import com.freiheit.toro.account.shared.model.settings.BirthdayVisibility;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.business.events.JCEventBus;
import de.justsoftware.onx.common.business.events.ServerEvent;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.events.UpdateEvent;
import de.justsoftware.onx.events.business.UpdateEventHandler;
import de.justsoftware.onx.extensions.business.StudienstiftungRegistrationService;
import de.justsoftware.onx.migration.business.ImportException;
import de.justsoftware.onx.migration.business.impl.ImportUpdateEventCollector;
import de.justsoftware.onx.migration.shared.server.model.DatabasePersonImportModel;
import de.justsoftware.onx.migration.studienstiftung.business.StudienstiftungImportService;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.business.impl.RegistrationServiceImpl;
import de.justsoftware.onx.person.business.model.RegistrationModel;
import de.justsoftware.onx.person.business.model.RegistrationValidationException;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.person.shared.model.RegistrationResult;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ParametersAreNonnullByDefault
public class StudienstiftungRegistrationServiceImpl
extends RegistrationServiceImpl
implements StudienstiftungRegistrationService {
    private static final Logger IMPORT_LOG = LoggerFactory.getLogger((String)"IMPORTLOG");
    @Autowired
    private PersonService _personService;
    @Autowired
    private UpdateEventHandler _updateHandler;
    @Autowired
    private JCEventBus _eventBus;
    @Autowired
    private StudienstiftungImportService _importService;
    private ImmutableSet<EntityId> _defaultMembershipEntityIds = ImmutableSet.of();

    public void setDefaultMembershipEntityIds(List<Long> ids) {
        this._defaultMembershipEntityIds = FluentIterable.from(ids).transform(EntityId.FROM_LONG).toSet();
    }

    @Override
    public RegistrationResult register(RegistrationModel registrationModel, String language) throws RegistrationValidationException {
        RegistrationResult registrationResult = super.register(registrationModel, Locale.GERMANY.getLanguage());
        try {
            ImportUpdateEventCollector eventCollector = new ImportUpdateEventCollector();
            this.importRegisteredPerson(Strings.nullToEmpty((String)registrationModel.getEmail()), registrationResult.getPersonId(), eventCollector);
            this.publishUpdateEvents(eventCollector);
        }
        catch (ImportException e) {
            IMPORT_LOG.error("Unable to import newly registered account " + registrationResult.getPersonId(), (Throwable)e);
        }
        return registrationResult;
    }

    private void importRegisteredPerson(String eMail, PersonId registeredUserId, ImportUpdateEventCollector eventCollector) throws ImportException {
        DatabasePersonImportModel importModelByMail = this._importService.importPerson(eMail, eventCollector);
        if (importModelByMail == null) {
            throw new ImportException("Cannot find user with email " + eMail + " in datasource.");
        }
        this._importService.importMembershipsAndSubscriptionsByExternalId((String)importModelByMail.getExternalId(), registeredUserId, (Set<EntityId>)this._defaultMembershipEntityIds, eventCollector);
        this._personService.activateAccountById(registeredUserId);
        IMPORT_LOG.info("Successfully registered and imported new user with email {}", (Object)eMail);
    }

    private void publishUpdateEvents(ImportUpdateEventCollector eventCollector) {
        this._updateHandler.onChanges((Iterable<? extends UpdateEvent<?>>)eventCollector.getUpdateEvents());
        this._eventBus.post((Iterable<? extends ServerEvent>)eventCollector.getServerEvents());
        eventCollector.clear();
    }

    @Override
    protected DBPerson createDBPerson(RegistrationModel registrationModel, String languageCode, boolean activated) {
        DBPerson result = super.createDBPerson(registrationModel, languageCode, activated);
        result.setBirthdayVisibility(BirthdayVisibility.NONE);
        return result;
    }
}

