/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.extensions.business.impl;

import com.freiheit.toro.common.shared.i18n.ExceptionMessages;
import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableListMultimap;
import de.justsoftware.gwt.i18n.dynamic.server.I18nMessagesFactory;
import de.justsoftware.gwt.i18n.dynamic.shared.model.I18nMessage;
import de.justsoftware.onx.common.shared.i18n.StudienstiftungMessages;
import de.justsoftware.onx.common.shared.model.ValidationError;
import de.justsoftware.onx.common.shared.util.Dates;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.migration.business.ImportException;
import de.justsoftware.onx.migration.shared.server.model.DatabasePersonImportModel;
import de.justsoftware.onx.migration.studienstiftung.business.StudienstiftungImportService;
import de.justsoftware.onx.person.business.impl.PersonValidatorImpl;
import de.justsoftware.onx.person.business.model.RegistrationModel;
import de.justsoftware.onx.person.model.DBPerson;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

@ParametersAreNonnullByDefault
public class StudienstiftungPersonValidatorImpl
extends PersonValidatorImpl {
    private static final Logger LOG = LoggerFactory.getLogger(StudienstiftungPersonValidatorImpl.class);
    private final I18nMessagesFactory _messageFactory = new I18nMessagesFactory();
    private final ExceptionMessages _exceptionMsgs = (ExceptionMessages)this._messageFactory.createProxy(ExceptionMessages.class);
    private final StudienstiftungMessages _sdvMessages = (StudienstiftungMessages)this._messageFactory.createProxy(StudienstiftungMessages.class);
    private final Map<String, I18nMessage> _i18nMap = this.createI18nMap();
    private StudienstiftungImportService _importService;

    @Required
    public void setStudienstiftungImportService(StudienstiftungImportService importService) {
        this._importService = importService;
    }

    @Override
    public ImmutableListMultimap<String, ValidationError> validateStaticRegistrationFields(RegistrationModel registration) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting the validation for new user " + registration.getFirstname() + " " + registration.getLastname());
        }
        ImmutableListMultimap.Builder result = ImmutableListMultimap.builder();
        result.putAll(super.validateStaticRegistrationFields(registration));
        try {
            String email = registration.getEmail();
            if (StringUtil.isBlank(email)) {
                this.addError("person.email", this._messageFactory.getMessage(this._exceptionMsgs.isInvalid(this._messageFactory.messageAsArgument(this._i18nMap.get("person.email")))), (ImmutableListMultimap.Builder<String, ValidationError>)result);
            } else {
                DatabasePersonImportModel importModel = this._importService.getAndMapPersonImportModel(email);
                if (importModel == null) {
                    this.addError("person.email", this._messageFactory.getMessage(this._sdvMessages.unknownAccount()), (ImmutableListMultimap.Builder<String, ValidationError>)result);
                } else {
                    DBPerson importedPerson = importModel.getPerson();
                    this.validateImportedField("person.firstname", importedPerson.getFirstName(), registration.getFirstname(), (ImmutableListMultimap.Builder<String, ValidationError>)result);
                    this.validateImportedField("person.lastname", importedPerson.getLastName(), registration.getLastname(), (ImmutableListMultimap.Builder<String, ValidationError>)result);
                    this.validateBirthday(importedPerson, registration, (ImmutableListMultimap.Builder<String, ValidationError>)result);
                    this.validateImportedField("person.email", importedPerson.getEmail(), registration.getEmail(), (ImmutableListMultimap.Builder<String, ValidationError>)result);
                }
            }
        }
        catch (ImportException e) {
            LOG.error("Exception during registration: ", (Throwable)e);
            this.addError("person.*", this._messageFactory.getMessage(this._exceptionMsgs.unableToLoadPerson(registration.getEmail())), (ImmutableListMultimap.Builder<String, ValidationError>)result);
        }
        ImmutableListMultimap fullresult = result.build();
        if (!fullresult.isEmpty()) {
            LOG.debug("Validation had errors, see stack trace.");
        }
        return fullresult;
    }

    private void validateBirthday(DBPerson importedPerson, RegistrationModel registration, ImmutableListMultimap.Builder<String, ValidationError> result) {
        DateWithoutTimezone personBirthday = importedPerson.getBirthday();
        DateWithoutTimezone registrationBirthday = registration.getBirthday();
        if (personBirthday == null && registrationBirthday != null || personBirthday != null && registrationBirthday == null || personBirthday != null && !Dates.areOnTheSameDay(personBirthday, registrationBirthday)) {
            this.addError("person.birthday", this._messageFactory.getMessage(this._exceptionMsgs.isInvalid(this._messageFactory.messageAsArgument(this._i18nMap.get("person.birthday")))), result);
        }
    }

    private void validateImportedField(String fieldId, @Nullable Object importedValue, @Nullable Object registrationValue, ImmutableListMultimap.Builder<String, ValidationError> result) {
        if (!Objects.equal((Object)importedValue, (Object)registrationValue)) {
            String message = this._exceptionMsgs.isInvalid(this._messageFactory.messageAsArgument(this._i18nMap.get(fieldId)));
            this.addError(fieldId, this._messageFactory.getMessage(message), result);
        }
    }

    @Override
    public boolean accountExists(String email) {
        DBPerson dbPerson;
        if (email != null && (dbPerson = this.getPersonService().getPersonByEmailOrNewmail(email)) != null) {
            return dbPerson.isActive();
        }
        return false;
    }
}

