/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.export.ldap.util;

import javax.annotation.CheckForNull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.NameNotFoundException;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.LdapTemplate;

@ParametersAreNonnullByDefault
public class LDAPUtil {
    private static final Logger LOG = LoggerFactory.getLogger(LDAPUtil.class);

    @CheckForNull
    public static DirContextAdapter lookupContext(LdapTemplate ldapTemplate, String distinguishedName) {
        try {
            DirContextOperations lookupContext = ldapTemplate.lookupContext(distinguishedName);
            if (!(lookupContext instanceof DirContextAdapter)) {
                String contextType = lookupContext != null ? lookupContext.getClass().toString() : "null";
                throw new UnsupportedOperationException("Unsupported context operations type - expected: " + DirContextAdapter.class + ", but found: " + contextType);
            }
            return (DirContextAdapter)lookupContext;
        }
        catch (NameNotFoundException e) {
            return null;
        }
    }

    public static void createContext(LdapTemplate ldapTemplate, String distinguishedName, DirContextAdapter context) throws NamingException, IllegalStateException {
        ldapTemplate.bind(distinguishedName, (Object)context, null);
    }

    public static void updateContext(LdapTemplate ldapTemplate, DirContextAdapter context) throws NamingException, IllegalStateException {
        ldapTemplate.modifyAttributes((DirContextOperations)context);
    }

    public static void deleteContext(LdapTemplate ldapTemplate, String distinguishedName) {
        DirContextAdapter context = LDAPUtil.lookupContext(ldapTemplate, distinguishedName);
        if (context != null) {
            ldapTemplate.unbind(distinguishedName, true);
        }
    }

    public static void setAttributes(DirContextAdapter context, Attributes attributes) {
        try {
            NamingEnumeration<? extends Attribute> add = attributes.getAll();
            while (add.hasMore()) {
                context.setAttribute(add.next());
            }
        }
        catch (NamingException e) {
            LOG.error("Failed to update attributes of dir context " + context.getDn(), (Throwable)e);
        }
    }
}

