/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.export.ldap.business;

import de.justsoftware.kafka.client.KafkaCleaningProducer;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.export.ldap.model.MemberGroupUpdateAction;
import de.justsoftware.onx.export.ldap.model.MemberGroupUpdateKafkaKey;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class MemberGroupExportUpdateProducer {
    private static final String TOPIC = "just.export.memberGroupUpdates";
    private static final Callback LOG_ERROR_CALLBACK = new Callback(){

        public void onCompletion(RecordMetadata metadata, Exception exception) {
            if (exception != null) {
                LOG.error("Could not publish role change event", (Throwable)exception);
            }
        }
    };
    private static final Logger LOG = LoggerFactory.getLogger(MemberGroupExportUpdateProducer.class);
    @CheckForNull
    private final KafkaCleaningProducer<String, String> _producer;

    public MemberGroupExportUpdateProducer(@Nullable KafkaCleaningProducer<String, String> producer) {
        this._producer = producer;
    }

    public void publish(EntityId entityId, MemberGroupUpdateAction updateAction) {
        this.send(new MemberGroupUpdateKafkaKey(entityId), updateAction);
    }

    private void send(MemberGroupUpdateKafkaKey key, MemberGroupUpdateAction msg) {
        if (this._producer != null) {
            this._producer.send(new ProducerRecord(TOPIC, (Object)key.toString(), (Object)msg.toString()), LOG_ERROR_CALLBACK);
        }
    }
}

