/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.export.ldap.business;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import de.justsoftware.onx.container.business.EntityMemberService;
import de.justsoftware.onx.container.business.EntityReadDataService;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityMemberWithPerson;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.export.ldap.business.LDAPMemberGroupExporter;
import de.justsoftware.onx.export.ldap.business.MemberGroupExportUpdateConsumer;
import de.justsoftware.onx.export.ldap.business.MemberRoleExportUpdateConsumer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class MemberGroupExportService {
    private final EntityService _entityService;
    private final EntityReadDataService _entityReadDataService;
    private final EntityMemberService _entityMemberService;
    private final MemberRoleExportUpdateConsumer _memberRoleExportUpdateConsumer;
    private final MemberGroupExportUpdateConsumer _memberGroupExportUpdateConsumer;
    private final List<LDAPMemberGroupExporter> _exporters;

    public MemberGroupExportService(EntityService entityService, EntityReadDataService entityReadDataService, EntityMemberService entityMemberService, MemberRoleExportUpdateConsumer memberRoleExportUpdateConsumer, MemberGroupExportUpdateConsumer memberGroupExportUpdateConsumer, List<LDAPMemberGroupExporter> exporters) {
        this._entityService = entityService;
        this._entityReadDataService = entityReadDataService;
        this._entityMemberService = entityMemberService;
        this._memberRoleExportUpdateConsumer = memberRoleExportUpdateConsumer;
        this._memberGroupExportUpdateConsumer = memberGroupExportUpdateConsumer;
        this._exporters = exporters;
    }

    public void triggerFullMemberGroupExport() {
        this._memberRoleExportUpdateConsumer.pause();
        this._memberGroupExportUpdateConsumer.pause();
        this._memberGroupExportUpdateConsumer.commitAll();
        this._memberRoleExportUpdateConsumer.commitAll();
        ClassLoader classLoader = this.getClass().getClassLoader();
        ImmutableSet entityTypes = (ImmutableSet)this._exporters.stream().map(LDAPMemberGroupExporter::getHandledEntityType).collect(ImmutableSet.toImmutableSet());
        ImmutableSetMultimap<EntityType, EntityId> entityIdsByTypes = this._entityReadDataService.getIdsByTypes((Iterable<EntityType>)entityTypes);
        ImmutableSet entityIds = ImmutableSet.copyOf((Collection)entityIdsByTypes.values());
        ImmutableListMultimap<EntityId, EntityMemberWithPerson> entityMembersByEntityIds = this._entityMemberService.getEntityMembersByEntityIds((Set<EntityId>)entityIds);
        Map<EntityId, DBEntity> entities = this._entityService.getByIds((Set<EntityId>)entityIds);
        entityIdsByTypes.keySet().forEach(entityType -> {
            ImmutableListMultimap.Builder memberRolesBuilder = ImmutableListMultimap.builder();
            ImmutableSet entityIdsForType = entityIdsByTypes.get(entityType);
            Map entitiesForType = Maps.filterKeys((Map)entities, arg_0 -> ((ImmutableSet)entityIdsForType).contains(arg_0));
            ListMultimap membersForType = Multimaps.filterKeys((ListMultimap)entityMembersByEntityIds, arg_0 -> ((ImmutableSet)entityIdsForType).contains(arg_0));
            membersForType.entries().forEach(entry -> memberRolesBuilder.put((Object)((DBEntity)entitiesForType.get(entry.getKey())), (Object)((EntityMemberWithPerson)entry.getValue())));
            ImmutableListMultimap entitiesAndMembersForType = memberRolesBuilder.build();
            this._exporters.parallelStream().forEach(exporter -> {
                Thread.currentThread().setContextClassLoader(classLoader);
                exporter.fullMemberGroupExport((EntityType)entityType, (ImmutableListMultimap<DBEntity, EntityMemberWithPerson>)entitiesAndMembersForType);
            });
        });
        this._memberRoleExportUpdateConsumer.resume();
        this._memberGroupExportUpdateConsumer.resume();
    }
}

