/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.export.csv.server.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.shared.model.NotLoggedInException;
import com.freiheit.toro.common.shared.model.PermissionDeniedException;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.business.ServerLocalizedMessages;
import de.justsoftware.onx.common.export.shared.annotation.CSVExportField;
import de.justsoftware.onx.common.export.shared.annotation.CSVExportId;
import de.justsoftware.onx.common.shared.i18n.BasicConstants;
import de.justsoftware.onx.common.shared.model.LongId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.common.shared.model.action.StaticEntityAction;
import de.justsoftware.onx.container.business.csvexport.EntityDataExportService;
import de.justsoftware.onx.container.shared.i18n.EntityConstants;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.server.model.export.EntityExportData;
import de.justsoftware.onx.export.csv.server.CSVExportService;
import de.justsoftware.onx.export.csv.server.i18n.CsvExportConstants;
import de.justsoftware.onx.person.business.attributes.errors.ConfigErrorException;
import de.justsoftware.onx.person.business.attributes.i18n.Language;
import de.justsoftware.onx.person.business.attributes.i18n.Translation;
import de.justsoftware.onx.person.business.attributes.i18n.Translations;
import de.justsoftware.onx.person.shared.i18n.ProfileConstants;
import de.justsoftware.onx.profile.business.ProfileAttributeTranslationService;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class CSVExportServiceImpl
implements CSVExportService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSVExportServiceImpl.class);
    private static final Joiner ROW_JOINER = Joiner.on((String)"\n").skipNulls();
    private static final Joiner COLUMN_JOINER = Joiner.on((String)";").useForNull("");
    private final Map<Class<?>, ValueConverter<?>> _converters = new HashMap();
    private final Settings _settings;
    private final I18nService _i18nService;
    private final EntityDataExportService _entityDataExportService;
    @Autowired
    private ProfileAttributeTranslationService _profileAttributeTranslationService;

    @Autowired
    public CSVExportServiceImpl(Settings settings, I18nService i18nService, EntityDataExportService entityDataExportService) {
        this._settings = settings;
        this._i18nService = i18nService;
        this._entityDataExportService = entityDataExportService;
        this.registerValueConverter(new StringConverter("\"", "\""));
        this.registerValueConverter(new DateConverter("yyyy-MM-dd HH:mm"));
        this.registerValueConverter(new IdConverter((Class<? extends LongId>)EntityId.class));
    }

    private void registerValueConverter(ValueConverter<?> converter) {
        this._converters.put(converter.getHandleClass(), converter);
    }

    @Nonnull
    private Translations getCustomMemberHeaderTranslations(Language language) throws ConfigErrorException {
        return new Translations(language, this._i18nService.createProxy(CsvExportConstants.class, language.toString()).overriddenMemberExportHeader());
    }

    @Nonnull
    private Translations getMemberHeaderTranslations(Language language) throws ConfigErrorException {
        ServerLocalizedMessages messages = this._i18nService.getLocalizedMessages(language.toString());
        ProfileConstants profileConstants = messages.profileConstants();
        BasicConstants basicConstants = messages.basicConstants();
        EntityConstants entityConstants = messages.entityConstants(EntityType.NETWORK);
        CsvExportConstants csvExportConstants = messages.csvExportConstants();
        return new Translations(language, (Iterable<Translation>)FluentIterable.from(this.getStaticPersonFieldTranslations(language, profileConstants, basicConstants)).append(EntityDataExportService.ExportColmnKeysTranslator.translateAll(language, csvExportConstants, profileConstants, entityConstants)).append(this.getProfileAttributeTranslations(language)).toList());
    }

    @Nonnull
    private Iterable<Translation> getProfileAttributeTranslations(final Language language) {
        ImmutableMap<String, String> profileAttributeTranslations = this._profileAttributeTranslationService.getProfileAttributeTranslations(language.toString());
        return FluentIterable.from((Iterable)profileAttributeTranslations.entrySet()).transform((Function)new NullPermeableFunction<Map.Entry<String, String>, Translation>(){

            @Override
            protected Translation applySafe(Map.Entry<String, String> input) {
                return new Translation(language, input.getKey(), input.getValue());
            }
        }).filter(Predicates.notNull());
    }

    @Nonnull
    private Iterable<Translation> getStaticPersonFieldTranslations(Language language, ProfileConstants profileConstants, BasicConstants basicConstants) {
        Joiner keys = Joiner.on((String)".");
        return ImmutableList.of((Object)this.createTranslation(language, "birthday", profileConstants.birthday(), keys), (Object)this.createTranslation(language, "localeTime", profileConstants.localeTime(), keys), (Object)this.createTranslation(language, "roleTitlePlural", basicConstants.roleTitlePlural(), keys), (Object)this.createTranslation(language, "roleTitleSingular", basicConstants.roleTitleSingular(), keys));
    }

    @Nonnull
    private Translation createTranslation(Language language, String key, String value, Joiner keys) {
        return new Translation(language, keys.join((Object)"BASIC", (Object)key, new Object[0]), value);
    }

    @Nonnull
    private List<Object[]> getExportData(Iterable<ImmutableMap<String, Object>> entityMemberExportData) {
        try {
            return FluentIterable.from(entityMemberExportData).transform((Function)new ExportDataRowMapper(this._settings.getCSVExportColumns())).toList();
        }
        catch (NotLoggedInException e) {
            throw new PermissionDeniedException();
        }
    }

    @Override
    public String getPlatformMembersAsCSV(AuthorizationCheckContextWithUserId authCtx) {
        authCtx.check(StaticAction.ADMIN_CSV_EXPORT);
        return this.getMemberAsCSV((Iterable<ImmutableMap<String, String>>)this._entityDataExportService.getPlatformMembersExportData(authCtx), authCtx);
    }

    @Override
    public String getEntityMembersAsCSV(EntityId entityId, AuthorizationContext authCtx) {
        authCtx.check((ItemId)entityId, (Action)StaticEntityAction.ENTITY_EXPORT_MEMBERS);
        return this.getMemberAsCSV((Iterable<ImmutableMap<String, String>>)this._entityDataExportService.getEntityMemberExportData(entityId, authCtx), authCtx);
    }

    @Nonnull
    private String getMemberAsCSV(Iterable<ImmutableMap<String, String>> csvData, AuthorizationCheckContextWithUserId authCtx) {
        Language lang = Language.of(authCtx.getLocale());
        Function headerTranslator = Functions.identity();
        try {
            headerTranslator = new EntityDataExportService.CSVHeaderTranslator(this.getCustomMemberHeaderTranslations(lang), this.getMemberHeaderTranslations(lang));
        }
        catch (ConfigErrorException e) {
            LOGGER.error("error mapping column header to translations:", (Throwable)e);
        }
        Function identity = Functions.identity();
        FluentIterable copyCast = FluentIterable.from(csvData).transform(identity);
        return this.getCSV(this._settings.getCSVExportColumns(), (Function<String, String>)headerTranslator, (Iterable<ImmutableMap<String, ? extends Object>>)copyCast);
    }

    @Override
    public String getNewEntityAsCSV(AuthorizationContext authCtx) {
        authCtx.check(StaticAction.ADMIN_CSV_EXPORT);
        ImmutableList allExportFieldInfos = FluentIterable.from((Object[])BeanUtils.getPropertyDescriptors(EntityExportData.class)).transform(FieldInfo.FROM_PROPERTY_DESCRIPTOR).filter(Predicates.notNull()).toSortedList((Comparator)Ordering.natural().onResultOf(FieldInfo.TO_ORDER_STRING));
        ImmutableList.Builder orderRef = ImmutableList.builder();
        ImmutableMap.Builder headerMap = ImmutableMap.builder();
        for (FieldInfo fi : allExportFieldInfos) {
            orderRef.add((Object)("" + fi.getOrder()));
            if (StringUtils.isEmpty((String)fi.getFieldId())) {
                headerMap.put((Object)("" + fi.getOrder()), (Object)fi.getFieldname());
                continue;
            }
            headerMap.put((Object)("" + fi.getOrder()), (Object)fi.getFieldId());
        }
        FluentIterable csvData = FluentIterable.from(this._entityDataExportService.getEntityExportData(null, null)).transform((Function)new EntityExportDataFieldInfoMapper((Iterable<FieldInfo>)allExportFieldInfos));
        return this.getCSV((Iterable<String>)orderRef.build(), (Function<String, String>)Functions.forMap((Map)headerMap.build()), (Iterable<ImmutableMap<String, ? extends Object>>)csvData);
    }

    @Nonnull
    private String getCSV(Iterable<String> orderedHeaderColumns, Function<String, String> headerTranslator, Iterable<ImmutableMap<String, ? extends Object>> csvData) {
        String csvHeader = FluentIterable.from(orderedHeaderColumns).transform(headerTranslator).join(COLUMN_JOINER);
        String csvValues = FluentIterable.from(csvData).transform((Function)new ExportDataRowMapper(orderedHeaderColumns)).transform((Function)new ExportRowHandler(new ExportColumnHandler(this._converters))).join(ROW_JOINER);
        return ROW_JOINER.join((Object)csvHeader, (Object)csvValues, new Object[]{""});
    }

    private static final class FieldInfo {
        public static final Function<FieldInfo, String> TO_ORDER_STRING = new NullPermeableFunction<FieldInfo, String>(){

            @Override
            protected String applySafe(FieldInfo input) {
                return "" + input.getOrder();
            }
        };
        public static final Function<PropertyDescriptor, FieldInfo> FROM_PROPERTY_DESCRIPTOR = new NullPermeableFunction<PropertyDescriptor, FieldInfo>(){

            @Override
            protected FieldInfo applySafe(PropertyDescriptor input) {
                Method readMethod = input.getReadMethod();
                CSVExportField csvExportField = readMethod.getAnnotation(CSVExportField.class);
                if (csvExportField != null) {
                    CSVExportField.CSVExportInfo[] exportFieldInfos;
                    for (CSVExportField.CSVExportInfo info : exportFieldInfos = csvExportField.value()) {
                        if (!CSVExportId.NEW_ENTITY_EXPORT.equals((Object)info.csvExportId())) continue;
                        return new FieldInfo(input.getName(), info.fieldId(), info.order(), readMethod);
                    }
                }
                return null;
            }
        };
        private final int _order;
        private final String _fieldname;
        private final String _fieldId;
        private final Method _readMethod;

        @ParametersAreNonnullByDefault
        private FieldInfo(String fieldname, String fieldId, int order, Method readMethod) {
            this._order = order;
            this._fieldname = fieldname;
            this._fieldId = fieldId;
            this._readMethod = readMethod;
        }

        public int getOrder() {
            return this._order;
        }

        @Nonnull
        public String getFieldname() {
            return this._fieldname;
        }

        @Nonnull
        public String getFieldId() {
            return this._fieldId;
        }

        @CheckForNull
        public Object getValueOn(@Nonnull EntityExportData bean) {
            try {
                return this._readMethod.invoke((Object)bean, (Object[])null);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new ServiceException(e);
            }
        }
    }

    private static final class IdConverter
    extends ValueConverter<LongId> {
        @ParametersAreNonnullByDefault
        public IdConverter(Class<? extends LongId> cls) {
            super(cls);
        }

        @Override
        protected String convertValue(LongId value) {
            if (value == null) {
                return "";
            }
            return Long.toString(value.getId());
        }
    }

    public static final class DateConverter
    extends ValueConverter<Date> {
        private final SimpleDateFormat _formatter;

        @ParametersAreNonnullByDefault
        public DateConverter(String format) {
            super(Date.class);
            this._formatter = new SimpleDateFormat(format);
        }

        @Override
        protected String convertValue(Date value) {
            if (value == null) {
                return "";
            }
            return this._formatter.format(value);
        }
    }

    private static final class StringConverter
    extends ValueConverter<String> {
        private final String _stringStartCharacter;
        private final String _stringEndCharacter;

        @ParametersAreNonnullByDefault
        public StringConverter(String startChar, String endChar) {
            super(String.class);
            this._stringStartCharacter = startChar;
            this._stringEndCharacter = endChar;
        }

        @Override
        protected String convertValue(String value) {
            if (Strings.isNullOrEmpty((String)value)) {
                return "";
            }
            return this._stringStartCharacter + value.replaceAll("\"", "\"\"").replaceAll("\n", " ").replaceAll("\r", "") + this._stringEndCharacter;
        }
    }

    private static abstract class ValueConverter<T> {
        private final Class<? extends T> _handleClass;

        public ValueConverter(@Nonnull Class<? extends T> handleClass) {
            this._handleClass = handleClass;
        }

        @Nonnull
        public Class<? extends T> getHandleClass() {
            return this._handleClass;
        }

        @Nonnull
        public String convert(@Nullable Object value) {
            return this.convertValue(value);
        }

        @Nonnull
        protected abstract String convertValue(@Nullable T var1);
    }

    @ParametersAreNonnullByDefault
    private static final class ExportDataColumnMapper
    implements Function<String, Object> {
        private final ImmutableMap<String, ? extends Object> _memberData;

        public ExportDataColumnMapper(ImmutableMap<String, ? extends Object> memberData) {
            this._memberData = memberData;
        }

        public Object apply(String key) {
            return key != null ? MoreObjects.firstNonNull((Object)this._memberData.get((Object)key), (Object)"") : "";
        }
    }

    @ParametersAreNonnullByDefault
    private static final class ExportDataRowMapper
    extends NullPermeableFunction<ImmutableMap<String, ? extends Object>, Object[]> {
        private final Iterable<String> _columnNames;

        public ExportDataRowMapper(Iterable<String> exportColumnNames) {
            this._columnNames = exportColumnNames;
        }

        @Override
        protected Object[] applySafe(ImmutableMap<String, ? extends Object> memberData) {
            return FluentIterable.from(this._columnNames).transform((Function)new ExportDataColumnMapper(memberData)).toArray(Object.class);
        }
    }

    @ParametersAreNonnullByDefault
    private static final class ExportColumnHandler
    extends NullPermeableFunction<Object, String> {
        private final Map<Class<?>, ValueConverter<?>> _converters;

        public ExportColumnHandler(Map<Class<?>, ValueConverter<?>> converters) {
            this._converters = converters;
        }

        @Override
        protected String applySafe(Object value) {
            ValueConverter<?> valueConverter = this._converters.get(value.getClass());
            return valueConverter != null ? valueConverter.convert(value) : value.toString();
        }
    }

    @ParametersAreNonnullByDefault
    private static final class ExportRowHandler
    extends NullPermeableFunction<Object[], String> {
        private final ExportColumnHandler _exportColumnHandler;

        public ExportRowHandler(ExportColumnHandler exportColumnHandler) {
            this._exportColumnHandler = exportColumnHandler;
        }

        @Override
        public String applySafe(Object[] dataRow) {
            return FluentIterable.from((Object[])dataRow).transform((Function)this._exportColumnHandler).join(COLUMN_JOINER);
        }
    }

    private static final class EntityExportDataFieldInfoMapper
    extends NullPermeableFunction<EntityExportData, ImmutableMap<String, ? extends Object>> {
        private final Iterable<FieldInfo> _allExportFieldInfos;

        @ParametersAreNonnullByDefault
        public EntityExportDataFieldInfoMapper(Iterable<FieldInfo> allExportFieldInfos) {
            this._allExportFieldInfos = allExportFieldInfos;
        }

        @Override
        protected ImmutableMap<String, ? extends Object> applySafe(EntityExportData bean) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (FieldInfo fieldInfo : this._allExportFieldInfos) {
                Object value = fieldInfo.getValueOn(bean);
                if (value == null) continue;
                builder.put((Object)("" + fieldInfo.getOrder()), value);
            }
            return builder.build();
        }
    }
}

