/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.events.shared.server.model;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.events.shared.server.model.ProcessingState;
import de.justsoftware.onx.events.shared.server.model.UpdateEventId;
import de.justsoftware.onx.events.shared.server.model.UpdateEventType;
import java.util.Date;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.joda.time.DateTime;

public class DBUpdateEvent {
    public static final Function<DBUpdateEvent, ItemId> TO_ITEM_ID = DBUpdateEvent::getItemId;
    public static final Function<DBUpdateEvent, UpdateEventType> TO_EVENT_TYPE = new Function<DBUpdateEvent, UpdateEventType>(){

        public UpdateEventType apply(DBUpdateEvent input) {
            return input != null ? input.getEventType() : null;
        }
    };
    private UpdateEventId _id;
    private Date _createdAt;
    private ProcessingState _state;
    private ItemId _itemId;
    private UpdateEventType _eventType;

    @Deprecated
    public DBUpdateEvent() {
    }

    public DBUpdateEvent(@Nonnull UpdateEventType eventType, @Nonnull ItemId itemId, @Nonnull ProcessingState state, @Nonnull Date createdAt) {
        this._eventType = eventType;
        this._itemId = itemId;
        this._state = state;
        this._createdAt = new Date(createdAt.getTime());
    }

    @CheckForNull
    public UpdateEventId getId() {
        return this._id;
    }

    public void setId(@Nonnull UpdateEventId id) {
        this._id = id;
    }

    @Nonnull
    public Date getCreatedAt() {
        return new Date(this._createdAt.getTime());
    }

    public void setCreatedAt(@Nonnull Date createdAt) {
        this._createdAt = new Date(createdAt.getTime());
    }

    @Nonnull
    public ProcessingState getState() {
        return this._state;
    }

    public void setState(@Nonnull ProcessingState state) {
        this._state = state;
    }

    @Nonnull
    public ItemId getItemId() {
        return this._itemId;
    }

    public void setItemId(@Nonnull ItemId itemId) {
        this._itemId = itemId;
    }

    @Nonnull
    public UpdateEventType getEventType() {
        return this._eventType;
    }

    public void setEventType(@Nonnull UpdateEventType eventType) {
        this._eventType = eventType;
    }

    @Nonnull
    public static DBUpdateEvent createNew(@Nonnull UpdateEventType eventType, @Nonnull ItemId itemId, @Nonnull DateTime date) {
        return new DBUpdateEvent(eventType, itemId, ProcessingState.NEW, date.toDate());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        DBUpdateEvent other = (DBUpdateEvent)obj;
        return Objects.equal((Object)this._itemId, (Object)other._itemId) && Objects.equal((Object)((Object)this._eventType), (Object)((Object)other._eventType));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this._itemId, this._eventType});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("itemId", (Object)this._itemId).add("eventType", (Object)this._eventType).toString();
    }
}

