/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.events.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import de.justsoftware.onx.common.business.InternalLinkService;
import de.justsoftware.onx.common.business.events.ServerEventHandler;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.mail.business.MailService;
import de.justsoftware.onx.mail.business.model.MailReceivers;
import de.justsoftware.onx.mail.business.model.ProfileDataMailModel;
import de.justsoftware.onx.mail.business.model.ProfileDataMailModelImpl;
import de.justsoftware.onx.migration.integration.persistence.PersonImportMappingDAO;
import de.justsoftware.onx.person.business.events.PersonDataChangedEventByUser;
import de.justsoftware.onx.person.model.DBPerson;
import java.lang.reflect.Field;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class SendEmailOnProfileChangedEventHandlerImpl
implements ServerEventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SendEmailOnProfileChangedEventHandlerImpl.class);
    private ImmutableSet<String> _personFieldsForEmail;
    private final MailService _mailService;
    private final Settings _settings;
    private final PersonImportMappingDAO _personImportMappingDAO;
    private final InternalLinkService _internalLinkService;
    private String _emailRecipient;

    @Autowired
    @ParametersAreNonnullByDefault
    public SendEmailOnProfileChangedEventHandlerImpl(MailService mailService, Settings settings, PersonImportMappingDAO personImportMappingDAO, InternalLinkService internalLinkService) {
        this._mailService = mailService;
        this._settings = settings;
        this._personImportMappingDAO = personImportMappingDAO;
        this._internalLinkService = internalLinkService;
    }

    @Required
    public void setEmailRecipient(@Nonnull String emailRecipient) {
        this._emailRecipient = emailRecipient;
    }

    String getEmailRecipient() {
        return this._emailRecipient;
    }

    @Required
    public void setPersonFieldsForEmail(@Nonnull List<String> personFieldsForEmail) {
        this._personFieldsForEmail = ImmutableSet.copyOf(personFieldsForEmail);
    }

    @Nonnull
    ImmutableSet<String> getPersonFieldsForEmail() {
        return this._personFieldsForEmail;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onProfileChangedEvent(@Nonnull PersonDataChangedEventByUser event) {
        boolean isNewProfile = event.getOldData() == null;
        PersonId personId = event.getPersonId();
        if (!isNewProfile && SendEmailOnProfileChangedEventHandlerImpl.hasChangedValues(this._personFieldsForEmail, event.getOldData(), event.getNewData())) {
            ProfileDataMailModel mailModel = this.createProfileDataMailModel(event.getNewData());
            LOG.info("Profile data has changed for person {}. Email will be sent", (Object)personId);
            this._mailService.sendProfileData(mailModel);
        } else {
            LOG.info("No changed profile data exist for profile with id {}. No email sent", (Object)personId);
        }
    }

    @Nonnull
    protected ProfileDataMailModel createProfileDataMailModel(@Nonnull DBPerson person) {
        ProfileDataMailModelImpl result = new ProfileDataMailModelImpl();
        result.setEmail(person.getEmail());
        result.setFirstname(person.getFirstName());
        result.setLastname(person.getLastName());
        result.setPersonId(person.getId());
        result.setReceiver(MailReceivers.forEmail(this._emailRecipient, this._settings));
        result.setExternalId(this._personImportMappingDAO.getExternalId(person.getId()));
        result.setUrl(this._internalLinkService.getProfileUrl(person.getId(), InternalLinkService.LinkType.URL));
        ImmutableMap.Builder personDataBuilder = ImmutableMap.builder();
        for (String fieldName : this._personFieldsForEmail) {
            try {
                Object value = SendEmailOnProfileChangedEventHandlerImpl.getValueByFieldName(person, fieldName);
                if (value == null) continue;
                personDataBuilder.put((Object)fieldName, (Object)value.toString());
            }
            catch (IllegalArgumentException e) {
                LOG.error("Wrong arguments to get value for " + fieldName, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.error("Cannot access field name " + fieldName, (Throwable)e);
            }
        }
        result.setProfileData((ImmutableMap<String, String>)personDataBuilder.build());
        return result;
    }

    @CheckForNull
    static Object getValueByFieldName(@Nonnull DBPerson dbPerson, @Nonnull String personFieldName) throws IllegalArgumentException, IllegalAccessException {
        for (Field classField : DBPerson.class.getDeclaredFields()) {
            if (!classField.isAnnotationPresent(de.justsoftware.onx.common.shared.model.Field.class)) continue;
            classField.setAccessible(true);
            de.justsoftware.onx.common.shared.model.Field fieldAnnotation = classField.getAnnotation(de.justsoftware.onx.common.shared.model.Field.class);
            if (!fieldAnnotation.id().equals(personFieldName)) continue;
            return classField.get(dbPerson);
        }
        return null;
    }

    private static boolean hasChangedValue(@Nonnull String personFieldName, @Nullable DBPerson oldData, @Nonnull DBPerson newData) {
        try {
            return oldData != null && !Objects.equal((Object)SendEmailOnProfileChangedEventHandlerImpl.getValueByFieldName(oldData, personFieldName), (Object)SendEmailOnProfileChangedEventHandlerImpl.getValueByFieldName(newData, personFieldName));
        }
        catch (IllegalArgumentException e) {
            LOG.error("Wrong arguments to access " + personFieldName, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.error("Could not access " + personFieldName, (Throwable)e);
        }
        return false;
    }

    private static boolean hasChangedValues(@Nonnull ImmutableSet<String> personFieldNames, @Nullable DBPerson oldData, @Nonnull DBPerson newData) {
        boolean hasChanged = oldData == null;
        UnmodifiableIterator it = personFieldNames.iterator();
        while (!hasChanged && it.hasNext()) {
            hasChanged = SendEmailOnProfileChangedEventHandlerImpl.hasChangedValue((String)it.next(), oldData, newData);
        }
        return hasChanged;
    }
}

