/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.drive.integration.persistence.ibatis;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.ibatis.sqlmap.client.SqlMapClient;
import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisPartitionResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.drive.business.model.DriveDocumentItem;
import de.justsoftware.onx.drive.business.model.DriveDocumentPublicity;
import de.justsoftware.onx.drive.integration.persistence.DriveDocumentItemDAO;
import de.justsoftware.onx.drive.integration.persistence.ibatis.DriveDocumentItemIbatisModel;
import de.justsoftware.onx.drive.shared.model.DriveDocumentId;
import de.justsoftware.onx.message.shared.model.ConversationId;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
@ParametersAreNonnullByDefault
public class IbatisDriveDocumentItemDAO
implements DriveDocumentItemDAO {
    private final IbatisStatementBuilder _statementBuilder;

    @Autowired
    public IbatisDriveDocumentItemDAO(StatementBuilderFactory statementBuilderFactory) {
        this._statementBuilder = statementBuilderFactory.ibatistStatementBuilder("DriveDocumentItem");
    }

    @Override
    public void storeItems(Table<DriveDocumentPublicity, DriveDocumentId, DriveDocumentItem> itemsToUpdate, SetMultimap<DriveDocumentPublicity, DriveDocumentId> itemsToDelete) {
        Sets.SetView allPublicities = Sets.union((Set)itemsToDelete.keySet(), (Set)itemsToUpdate.rowKeySet());
        if (allPublicities.isEmpty()) {
            return;
        }
        this._statementBuilder.batch(arg_0 -> this.lambda$storeItems$0((Set)allPublicities, itemsToUpdate, itemsToDelete, arg_0));
    }

    @Override
    public ImmutableMap<DriveDocumentId, DriveDocumentItem> getByIds(DriveDocumentPublicity documentPublicity, Set<DriveDocumentId> ids) {
        return ((IbatisPartitionResultBuilder)this._statementBuilder.select("getDriveDocumentItemsByIds").partition("ids", ids, "publicity", (Object)documentPublicity)).asMap(DriveDocumentItemIbatisModel::getId, DriveDocumentItemIbatisModel::toItem);
    }

    @Override
    public void migrateToNewConversationId(Map<String, ConversationId> ids) {
        this._statementBuilder.batch(sqlMapClient -> ids.forEach((originalId, migratedId) -> this._statementBuilder.update("migrateToNewConversationId").param("originalId", originalId, "migratedId", migratedId)));
    }

    @Override
    public void updateParentId(ItemId originalId, ItemId newId) {
        this._statementBuilder.update("updateParentId").param("originalId", originalId.asString(), "migratedId", newId.asString());
    }

    private /* synthetic */ void lambda$storeItems$0(Set allPublicities, Table itemsToUpdate, SetMultimap itemsToDelete, SqlMapClient sqlMapClient) throws SQLException {
        for (DriveDocumentPublicity documentPublicity : allPublicities) {
            Map items = itemsToUpdate.row((Object)documentPublicity);
            Sets.SetView allForPublicity = Sets.union(items.keySet(), (Set)itemsToDelete.get((Object)documentPublicity));
            if (allForPublicity.isEmpty()) continue;
            this._statementBuilder.delete("deleteItems").partition("ids", allForPublicity, "publicity", (Object)documentPublicity);
            for (DriveDocumentItem item : items.values()) {
                this._statementBuilder.insert("insertItem").param("item", item, "publicity", (Object)documentPublicity);
            }
        }
    }
}

