/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.drive.business.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableTable;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.common.shared.model.component.StaticComponentType;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.container.shared.server.model.ItemVisitor;
import de.justsoftware.onx.drive.business.model.DriveDocumentPublicity;
import de.justsoftware.onx.drive.shared.model.DriveDocumentId;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;

@ParametersAreNonnullByDefault
public class DriveDocumentItem
implements Item<DriveDocumentId> {
    private final DriveDocumentId _id;
    private final DriveDocumentPublicity _publicity;
    private final ItemId _parent;
    private final String _name;
    private final long _fileSize;
    private final String _mimeType;
    private final DateTime _changeDate;

    public DriveDocumentItem(DriveDocumentId id, DriveDocumentPublicity publicity, ItemId parent, String name, long fileSize, String mimeType, DateTime changeDate) {
        this._id = id;
        this._publicity = publicity;
        this._parent = parent;
        this._name = name;
        this._fileSize = fileSize;
        this._mimeType = mimeType;
        this._changeDate = changeDate;
    }

    @Override
    public DriveDocumentId getId() {
        return this._id;
    }

    @Nonnull
    public DriveDocumentPublicity getPublicity() {
        return this._publicity;
    }

    @Override
    @Nonnull
    public ItemId getParentId() {
        return this._parent;
    }

    @Override
    @Nonnull
    public ComponentType getModuleType() {
        return StaticComponentType.DOCUMENT;
    }

    @Override
    public <T> T accept(ItemVisitor<T> v) {
        return v.visit(this);
    }

    @Nonnull
    public String getName() {
        return this._name;
    }

    public long getFileSize() {
        return this._fileSize;
    }

    @Nonnull
    public String getMimeType() {
        return this._mimeType;
    }

    @Nonnull
    public DateTime getChangeDate() {
        return this._changeDate;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this._id).add("parent", (Object)this._parent).add("name", (Object)this._name).add("fileSize", this._fileSize).add("mimeType", (Object)this._mimeType).add("changeDate", (Object)this._changeDate).toString();
    }

    @Nonnull
    public static ImmutableTable<DriveDocumentPublicity, DriveDocumentId, DriveDocumentItem> indexDriveDocumentItems(Iterable<DriveDocumentItem> items) {
        ImmutableTable.Builder itemsBuilder = ImmutableTable.builder();
        for (DriveDocumentItem item : items) {
            itemsBuilder.put((Object)item.getPublicity(), (Object)item.getId(), (Object)item);
        }
        return itemsBuilder.build();
    }
}

