/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.drive.business.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.container.shared.model.IdParseException;
import de.justsoftware.onx.drive.business.model.DriveChangePurpose;
import de.justsoftware.onx.drive.shared.model.DriveDocumentId;
import de.justsoftware.onx.kafka.AbstractKafkaConsumer;
import de.justsoftware.onx.kafka.KafkaConfigurationProvider;
import de.justsoftware.onx.kafka.KafkaConsumerContext;
import de.justsoftware.onx.like.business.LikeService;
import de.justsoftware.onx.like.integration.persistence.model.SubscriptionWithDate;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy(value=false)
@ParametersAreNonnullByDefault
public class DriveSubscriptionsConsumer
extends AbstractKafkaConsumer<String, String> {
    static final String TOPIC = "just.drive.changes";
    private static final Logger LOG = LoggerFactory.getLogger(DriveSubscriptionsConsumer.class);
    private final LikeService _likeService;

    @Autowired
    public DriveSubscriptionsConsumer(TransactionHelper transactionHelper, KafkaConfigurationProvider kafkaConfigurationProvider, LikeService likeService) {
        this(kafkaConfigurationProvider.stringConsumer("just.toro.DriveSubscriptionsConsumer"), transactionHelper, likeService);
    }

    @VisibleForTesting
    public DriveSubscriptionsConsumer(@Nullable Consumer<String, String> consumer, TransactionHelper transactionHelper, LikeService likeService) {
        super(consumer, transactionHelper, TOPIC);
        this._likeService = likeService;
    }

    @Override
    protected void process(ConsumerRecords<String, String> records, KafkaConsumerContext context) {
        ArrayList newSubscriptions = Lists.newArrayList();
        for (ConsumerRecord record : records) {
            JsonNode parsedJson;
            if (record.value() == null || (parsedJson = this.parseJson((String)record.value())) == null) continue;
            try {
                com.google.common.base.Optional<DriveChangePurpose> changePurpose = DriveSubscriptionsConsumer.parseChangePurpose(parsedJson, "purpose");
                if (changePurpose.isPresent() && DriveChangePurpose.DOCUMENT_TO_DRIVE_MIGRATION.equals(changePurpose.get())) continue;
                for (JsonNode triggerNode : parsedJson.path("triggers")) {
                    JsonNode docIdNode = triggerNode.path("documentId");
                    if (docIdNode.isMissingNode()) {
                        LOG.warn("Received a trigger node without 'documentId': " + triggerNode.toString());
                        continue;
                    }
                    DriveDocumentId documentId = new DriveDocumentId(docIdNode.asText());
                    if (!"NEW_FILE".equals(triggerNode.path("type").asText())) continue;
                    DateTime changeDate = DriveSubscriptionsConsumer.parseDate(triggerNode, "changeDate").toJavaUtil().orElseGet(() -> (DateTime)DriveSubscriptionsConsumer.parseDate(parsedJson, "changeDate").or(DateTime::now));
                    PersonId ownerId = DriveSubscriptionsConsumer.parseOwner(triggerNode).orElseGet(() -> DriveSubscriptionsConsumer.parseOwner(parsedJson).orElse(null));
                    if (ownerId == null) continue;
                    newSubscriptions.add(new SubscriptionWithDate(ownerId, documentId, changeDate));
                }
            }
            catch (IdParseException ex) {
                this.getLog().warn("Got change with unparseable itemId; skipping", (Throwable)ex);
            }
        }
        this._likeService.subscribeAndOverwriteOldSubscriptions(newSubscriptions);
    }

    @Nonnull
    private static Optional<PersonId> parseOwner(JsonNode parsedJson) {
        return DriveSubscriptionsConsumer.parsePerson(parsedJson, "ownerId");
    }

    @Override
    protected Logger getLog() {
        return LOG;
    }
}

