/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.drive.business.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import de.justsoftware.onx.common.business.events.JCEventBus;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.container.business.events.DriveShareAccessGrantEvent;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.drive.shared.model.DriveDocumentId;
import de.justsoftware.onx.drive.shared.model.DriveShareId;
import de.justsoftware.onx.kafka.AbstractKafkaConsumer;
import de.justsoftware.onx.kafka.KafkaConfigurationProvider;
import de.justsoftware.onx.kafka.KafkaConsumerContext;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy(value=false)
@ParametersAreNonnullByDefault
public class DriveShareMembersUpdatesNotificationCreator
extends AbstractKafkaConsumer<String, String> {
    @VisibleForTesting
    static final String TOPIC = "just.drive.shares.members";
    private static final Logger LOGGER = LoggerFactory.getLogger(DriveShareMembersUpdatesNotificationCreator.class);
    private final JCEventBus _eventBus;

    @Autowired
    public DriveShareMembersUpdatesNotificationCreator(KafkaConfigurationProvider kafkaConfigurationProvider, TransactionHelper transactionHelper, JCEventBus eventBus) {
        this(kafkaConfigurationProvider.stringConsumer("just.toro.DriveShareCreationNotificationCreator"), transactionHelper, eventBus);
    }

    DriveShareMembersUpdatesNotificationCreator(@Nullable Consumer<String, String> consumer, TransactionHelper transactionHelper, JCEventBus eventBus) {
        super(consumer, transactionHelper, TOPIC);
        this._eventBus = eventBus;
    }

    @Override
    protected Logger getLog() {
        return LOGGER;
    }

    @Override
    protected void process(ConsumerRecords<String, String> records, KafkaConsumerContext context) {
        for (ConsumerRecord record : records) {
            this.process((ConsumerRecord<String, String>)record, context);
        }
    }

    @Override
    @VisibleForTesting
    void process(ConsumerRecord<String, String> record, KafkaConsumerContext context) {
        ShareMemberKey shareMember = ShareMemberKey.parse((String)record.key());
        if (shareMember == null) {
            return;
        }
        String value = (String)record.value();
        if (value == null) {
            return;
        }
        JsonNode json = this.parseJson(value);
        PersonId executor = PersonId.parse((String)DriveShareMembersUpdatesNotificationCreator.parseString(json, "executor").orNull());
        if (executor == null) {
            LOGGER.warn("Got drive Share update without proper executor: {}", (Object)json);
            return;
        }
        if (executor.equals(shareMember._memberId)) {
            return;
        }
        String shareName = (String)DriveShareMembersUpdatesNotificationCreator.parseString(json, "name").orNull();
        if (shareName == null) {
            LOGGER.warn("Got share update without Share name: {}", (Object)json);
            return;
        }
        DriveDocumentId rootFolderId = (DriveDocumentId)DriveShareMembersUpdatesNotificationCreator.parseString(json, "rootFolderId").transform(DriveDocumentId::new).orNull();
        if (rootFolderId == null) {
            LOGGER.warn("Got share update without root folder ID: {}", (Object)json);
            return;
        }
        context.afterCommit(() -> this._eventBus.post(new DriveShareAccessGrantEvent(shareMember._memberId, executor, shareMember._shareItemId, shareName)));
    }

    @ParametersAreNonnullByDefault
    private static final class ShareMemberKey {
        private static final Splitter MEMBER_KEY_SPLITTER = Splitter.on((char)';');
        final DriveShareId _shareItemId;
        final PersonId _memberId;

        private ShareMemberKey(DriveShareId shareItemId, PersonId memberId) {
            this._shareItemId = shareItemId;
            this._memberId = memberId;
        }

        @CheckForNull
        static ShareMemberKey parse(@Nullable String shareMemberKey) {
            if (shareMemberKey == null) {
                return null;
            }
            List splittedKey = MEMBER_KEY_SPLITTER.splitToList((CharSequence)shareMemberKey);
            if (splittedKey.size() != 2) {
                LOGGER.warn("Got drive Share member update with improper key: " + shareMemberKey);
                return null;
            }
            ItemId parsedItemId = ItemId.parseSafe((String)splittedKey.get(0));
            if (!(parsedItemId instanceof DriveShareId)) {
                LOGGER.warn("Got drive Share update without proper Share ID: " + (String)splittedKey.get(0));
                return null;
            }
            DriveShareId shareItemId = (DriveShareId)parsedItemId;
            PersonId memberId = PersonId.parse((String)splittedKey.get(1));
            if (memberId == null) {
                LOGGER.warn("Got drive Share update without proper member id: {}", splittedKey.get(1));
                return null;
            }
            return new ShareMemberKey(shareItemId, memberId);
        }
    }
}

