/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.drive.business.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import de.justsoftware.onx.chat.integration.persistence.file.model.MultipartFileResource;
import de.justsoftware.onx.common.server.FileUploadRestTemplate;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.DriveChangeId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.drive.business.DriveInternalApiConnector;
import de.justsoftware.onx.drive.business.model.DriveChangePurpose;
import de.justsoftware.onx.drive.business.model.DriveRestoreChangeResponse;
import de.justsoftware.onx.drive.business.model.DriveRestorePurpose;
import de.justsoftware.onx.drive.business.model.DriveTempFile;
import de.justsoftware.onx.drive.business.model.DriveUploadResultModel;
import de.justsoftware.onx.drive.shared.model.DriveDocumentId;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;
import org.springframework.web.multipart.MultipartFile;

@Service
@ParametersAreNonnullByDefault
public class DriveInternalApiConnectorImpl
implements DriveInternalApiConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(DriveInternalApiConnectorImpl.class);
    private final String _driveInternalApiUrl;
    private final RestOperations _restTemplate;

    @Autowired
    public DriveInternalApiConnectorImpl(@Value(value="${just-drive.internalApi.url}") String driveInternalApiUrl, @Qualifier(value="defaultRestTemplate") RestOperations restTemplate) {
        this._driveInternalApiUrl = driveInternalApiUrl;
        this._restTemplate = restTemplate;
    }

    @Override
    public void reindexDriveDocuments() {
        try {
            this._restTemplate.postForLocation(this._driveInternalApiUrl + "/reindex", null, new Object[0]);
        }
        catch (RestClientException e) {
            throw DriveInternalApiConnectorImpl.logAndThrow("Failed to reindex drive documents.", e);
        }
    }

    @Override
    public boolean isAvailable() {
        try {
            this._restTemplate.getForObject(this._driveInternalApiUrl + "/status", String.class, new Object[0]);
            return true;
        }
        catch (RestClientException e) {
            LOGGER.error("Failed get the status of the internal drive api", (Throwable)e);
            return false;
        }
    }

    @Override
    public void publishAllChanges() {
        try {
            this._restTemplate.postForLocation(this._driveInternalApiUrl + "/publishChanges", null, new Object[0]);
        }
        catch (RestClientException e) {
            throw DriveInternalApiConnectorImpl.logAndThrow("Failed to publish all drive changes.", e);
        }
    }

    @Override
    public void publishAllDocuments() {
        try {
            this._restTemplate.postForLocation(this._driveInternalApiUrl + "/publishDocuments", null, new Object[0]);
        }
        catch (RestClientException e) {
            throw DriveInternalApiConnectorImpl.logAndThrow("Failed to publish all drive documents.", e);
        }
    }

    @Override
    public void publishDrivePermissions() {
        try {
            this._restTemplate.postForLocation(this._driveInternalApiUrl + "/publishDrivePermissions", null, new Object[0]);
        }
        catch (RestClientException e) {
            throw DriveInternalApiConnectorImpl.logAndThrow("Failed to publish all drive permissions.", e);
        }
    }

    @Override
    public void runDriveHistoryCompactionJob() {
        try {
            this._restTemplate.postForLocation(this._driveInternalApiUrl + "/runDriveHistoryCompactionJob", null, new Object[0]);
        }
        catch (RestClientException e) {
            throw DriveInternalApiConnectorImpl.logAndThrow("Failed to run job to compact drive history.", e);
        }
    }

    @Override
    public DriveRestoreChangeResponse restoreDriveChange(DriveChangeId driveChange, PersonId personId, DriveRestorePurpose purpose) {
        try {
            DriveRestoreChangeResponse result;
            HashMap<String, Object> reqContent = new HashMap<String, Object>();
            reqContent.put("change", driveChange.getId());
            reqContent.put("person", personId.idAsLongValue());
            if (purpose != null) {
                reqContent.put("purpose", purpose.getPurpose());
            }
            if ((result = (DriveRestoreChangeResponse)this._restTemplate.postForObject(this._driveInternalApiUrl + "/restoreDriveChange", reqContent, DriveRestoreChangeResponse.class, new Object[0])) == null) {
                throw DriveInternalApiConnectorImpl.logAndThrow("Failed to restore drive change " + driveChange + ".", null);
            }
            return result;
        }
        catch (RestClientException e) {
            throw DriveInternalApiConnectorImpl.logAndThrow("Failed to restore drive change " + driveChange + ".", e);
        }
    }

    @Override
    public ImmutableList<DriveTempFile> uploadTempFiles(PersonId ownerId, ImmutableList<MultipartFile> files) {
        long overallSize = files.stream().mapToLong(MultipartFile::getSize).sum();
        FileUploadRestTemplate rest = new FileUploadRestTemplate(overallSize);
        LinkedMultiValueMap postData = new LinkedMultiValueMap();
        postData.add((Object)"ownerId", (Object)ownerId.idAsLongValue());
        try {
            for (MultipartFile file : files) {
                postData.add((Object)"files", (Object)new MultipartFileResource(file));
            }
            ResponseEntity tempFiles = rest.exchange(this._driveInternalApiUrl + "/tmp/upload", HttpMethod.POST, new HttpEntity((Object)postData), (ParameterizedTypeReference)new ParameterizedTypeReference<List<DriveTempFile>>(){}, new Object[0]);
            return ImmutableList.copyOf((Collection)((Collection)tempFiles.getBody()));
        }
        catch (RestClientException e) {
            throw DriveInternalApiConnectorImpl.logAndThrow("Failed to upload temporary files.", e);
        }
    }

    @Nonnull
    private static ServiceException logAndThrow(String msg, @Nullable Throwable e) {
        LOGGER.error(msg, e);
        return new ServiceException(msg + "See log for more details.", e);
    }

    @Override
    public DriveDocumentId replaceFile(ItemId itemId, File file, PersonId owner, DriveChangePurpose purpose) {
        FileUploadRestTemplate template = new FileUploadRestTemplate(file.length());
        LinkedMultiValueMap postData = new LinkedMultiValueMap();
        postData.add((Object)"ownerId", (Object)owner.toString());
        postData.add((Object)"file", (Object)new FileSystemResource(file));
        if (purpose != null) {
            postData.add((Object)"purpose", (Object)purpose.getPurpose());
        }
        try {
            DriveUploadResultModel result = (DriveUploadResultModel)template.postForObject(this._driveInternalApiUrl + "/item/" + itemId.asString() + "/replace", postData, DriveUploadResultModel.class, new Object[0]);
            if (result == null) {
                throw DriveInternalApiConnectorImpl.logAndThrow("Failed to upload file." + file.getName(), null);
            }
            return result.getId();
        }
        catch (RestClientException e) {
            throw DriveInternalApiConnectorImpl.logAndThrow("Failed to upload file." + file.getName(), e);
        }
    }

    @Override
    public boolean deleteDocument(PersonId deletingUser, DriveDocumentId documentToDelete) {
        try {
            ImmutableMap urlVariables = ImmutableMap.of((Object)"documentId", (Object)documentToDelete.getId(), (Object)"userId", (Object)deletingUser);
            this._restTemplate.delete(this._driveInternalApiUrl + "/file/{documentId}/delete?deletingUser={userId}", (Map)urlVariables);
            return true;
        }
        catch (RestClientException e) {
            LOGGER.error("Failed to delete file '" + documentToDelete.asString() + "' with user '" + deletingUser.toString() + "'.", (Throwable)e);
            return false;
        }
    }

    @Override
    public void checkHealth() {
        try {
            this._restTemplate.getForEntity(this._driveInternalApiUrl + "/monitoring/health", JsonNode.class, new Object[0]);
        }
        catch (HttpStatusCodeException e) {
            throw new ServiceException("Drive health check returned status: " + e.getMessage() + " (" + e.getResponseBodyAsString() + ")");
        }
    }
}

