/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.drive.business;

import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.DriveChangeId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.drive.business.model.DriveChangePurpose;
import de.justsoftware.onx.drive.business.model.DriveRestoreChangeResponse;
import de.justsoftware.onx.drive.business.model.DriveRestorePurpose;
import de.justsoftware.onx.drive.business.model.DriveTempFile;
import de.justsoftware.onx.drive.shared.model.DriveDocumentId;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.web.multipart.MultipartFile;

@ParametersAreNonnullByDefault
public interface DriveInternalApiConnector {
    public void publishAllChanges();

    public void publishAllDocuments();

    public void reindexDriveDocuments();

    public boolean isAvailable();

    @Nonnull
    public DriveRestoreChangeResponse restoreDriveChange(DriveChangeId var1, PersonId var2, @Nullable DriveRestorePurpose var3);

    @Nonnull
    public ImmutableList<DriveTempFile> uploadTempFiles(PersonId var1, ImmutableList<MultipartFile> var2);

    @Nonnull
    public DriveDocumentId replaceFile(ItemId var1, File var2, PersonId var3, @Nullable DriveChangePurpose var4);

    public void publishDrivePermissions();

    public void runDriveHistoryCompactionJob();

    public boolean deleteDocument(PersonId var1, DriveDocumentId var2);

    public void checkHealth();
}

