/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.document.shared.model.db;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.util.Dates;
import de.justsoftware.onx.container.shared.model.Identifiable;
import de.justsoftware.onx.document.shared.model.DocumentId;
import de.justsoftware.onx.document.shared.model.DocumentVersionId;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.io.Serializable;
import java.util.Date;

public class DBDocumentVersion
implements Serializable,
Identifiable<DocumentVersionId> {
    public static final Function<DBDocumentVersion, String> GET_FILENAME = new Function<DBDocumentVersion, String>(){

        public String apply(DBDocumentVersion input) {
            return input != null ? input.getFilename() : null;
        }
    };
    public static final Function<DBDocumentVersion, Integer> GET_VERSION = new NullPermeableFunction<DBDocumentVersion, Integer>(){

        @Override
        protected Integer applySafe(DBDocumentVersion input) {
            return input.getVersion();
        }
    };
    private static final long serialVersionUID = -7039657340233536125L;
    private DocumentVersionId _id;
    private DocumentId _documentId;
    private Integer _version;
    private String _filename;
    private String _url;
    private PersonId _uploadedById;
    private Date _uploadedAt;
    private long _size;
    private Long _fileTypeId;
    private Integer _restoredFrom;
    private boolean _notifiedOthers;

    public DBDocumentVersion() {
    }

    public DBDocumentVersion(DBDocumentVersion o) {
        this._id = o.getId();
        this._documentId = o.getDocumentId();
        this._version = o.getVersion();
        this._filename = o.getFilename();
        this._url = o.getUrl();
        this._uploadedById = o.getUploadedById();
        this._uploadedAt = o.getUploadedAt();
        this._size = o.getSize();
        this._fileTypeId = o.getFileTypeId();
        this._restoredFrom = o.getRestoredFrom();
        this._notifiedOthers = o.isNotifiedOthers();
    }

    public void setId(DocumentVersionId id) {
        this._id = id;
    }

    @Override
    public DocumentVersionId getId() {
        return this._id;
    }

    public String getFilename() {
        return this._filename;
    }

    public void setFilename(String filename) {
        this._filename = filename;
    }

    public String getUrl() {
        return this._url;
    }

    public void setUrl(String url) {
        this._url = url;
    }

    public PersonId getUploadedById() {
        return this._uploadedById;
    }

    public void setUploadedById(PersonId uploadedById) {
        this._uploadedById = uploadedById;
    }

    public Date getUploadedAt() {
        return Dates.clone(this._uploadedAt);
    }

    public void setUploadedAt(Date uploadedAt) {
        this._uploadedAt = Dates.clone(uploadedAt);
    }

    public long getSize() {
        return this._size;
    }

    public void setSize(long size) {
        this._size = size;
    }

    public Long getFileTypeId() {
        return this._fileTypeId;
    }

    public void setFileTypeId(Long fileTypeId) {
        this._fileTypeId = fileTypeId;
    }

    public Integer getRestoredFrom() {
        return this._restoredFrom;
    }

    public void setRestoredFrom(Integer restoredFrom) {
        this._restoredFrom = restoredFrom;
    }

    public void setVersion(Integer version) {
        this._version = version;
    }

    public Integer getVersion() {
        return this._version;
    }

    public void setDocumentId(DocumentId documentId) {
        this._documentId = documentId;
    }

    public DocumentId getDocumentId() {
        return this._documentId;
    }

    public boolean isNotifiedOthers() {
        return this._notifiedOthers;
    }

    public void setNotifiedOthers(boolean notifiedOthers) {
        this._notifiedOthers = notifiedOthers;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this._id).add("documentId", (Object)this._documentId).add("version", (Object)this._version).add("filename", (Object)this._filename).add("url", (Object)this._url).add("uploadedById", (Object)this._uploadedById).add("uploadedAt", (Object)this._uploadedAt).add("size", this._size).add("fileTypeId", (Object)this._fileTypeId).add("restoredFrom", (Object)this._restoredFrom).add("notifiedOthers", this._notifiedOthers).toString();
    }
}

