/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.document.shared.model.db;

import com.freiheit.toro.common.shared.i18n.DocumentConstants;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import de.justsoftware.onx.common.shared.model.EnumWithLongId;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.util.Dates;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.Identifiable;
import de.justsoftware.onx.document.shared.model.DocumentId;
import java.io.Serializable;
import java.util.Date;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DBDocument
implements Serializable,
Identifiable<DocumentId> {
    private static final long serialVersionUID = 1L;
    private DocumentId _id;
    private GlobalId _parentId;
    private String _description;
    private String _keywords;
    private long _downloadCount;
    private PersonId _checkedOutById;
    private Date _checkedOutAt;
    private Status _status;
    private PersonId _statusChangedById;
    private Date _statusChangedAt;
    private Date _modifiedAt;

    public DBDocument() {
    }

    public DBDocument(DBDocument doc) {
        this._id = doc.getId();
        this._parentId = doc.getParentId();
        this._description = doc.getDescription();
        this._keywords = doc.getKeywords();
        this._downloadCount = doc.getDownloadCount();
        this._checkedOutById = doc.getCheckedOutById();
        this.setCheckedOutAt(doc.getCheckedOutAt());
        this._status = doc.getStatus();
        this._statusChangedById = doc.getStatusChangedById();
        this.setStatusChangedAt(doc.getStatusChangedAt());
        this.setModifiedAt(doc.getModifiedAt());
    }

    public void setId(DocumentId id) {
        this._id = id;
    }

    @Override
    public DocumentId getId() {
        return this._id;
    }

    public void setParentId(GlobalId parentId) {
        this._parentId = parentId;
    }

    public GlobalId getParentId() {
        return this._parentId;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public String getKeywords() {
        return this._keywords;
    }

    public void setKeywords(String keywords) {
        this._keywords = keywords;
    }

    public long getDownloadCount() {
        return this._downloadCount;
    }

    public void setDownloadCount(long downloadCount) {
        this._downloadCount = downloadCount;
    }

    public PersonId getCheckedOutById() {
        return this._checkedOutById;
    }

    public void setCheckedOutById(PersonId checkedOutById) {
        this._checkedOutById = checkedOutById;
    }

    @CheckForNull
    public Date getCheckedOutAt() {
        return Dates.clone(this._checkedOutAt);
    }

    public void setCheckedOutAt(@Nullable Date checkedOutAt) {
        this._checkedOutAt = Dates.clone(checkedOutAt);
    }

    public Status getStatus() {
        return this._status;
    }

    public void setStatus(Status status) {
        this._status = status;
    }

    public void setStatusChangedById(PersonId statusChangedById) {
        this._statusChangedById = statusChangedById;
    }

    public PersonId getStatusChangedById() {
        return this._statusChangedById;
    }

    @CheckForNull
    public Date getStatusChangedAt() {
        return Dates.clone(this._statusChangedAt);
    }

    public void setStatusChangedAt(@Nullable Date statusChangedAt) {
        this._statusChangedAt = Dates.clone(statusChangedAt);
    }

    @Nonnull
    public Date getModifiedAt() {
        return Dates.clone(this._modifiedAt);
    }

    public void setModifiedAt(@Nonnull Date modifiedAt) {
        this._modifiedAt = Dates.clone(modifiedAt);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this._id).add("parentId", (Object)this._parentId).add("description", (Object)this._description).add("keywords", (Object)this._keywords).add("downloadCount", this._downloadCount).add("checkedOutById", (Object)this._checkedOutById).add("checkedOutAt", (Object)this._checkedOutAt).add("status", (Object)this._status).add("statusChangedById", (Object)this._statusChangedById).add("statusChangedAt", (Object)this._statusChangedAt).add("modifiedAt", (Object)this._modifiedAt).toString();
    }

    public static enum Status implements EnumWithLongId
    {
        EMPTY(0){

            @Override
            public String getI18nStatus(DocumentConstants i18nConstants) {
                return i18nConstants.statusEmpty();
            }
        }
        ,
        DRAFT(1){

            @Override
            public String getI18nStatus(DocumentConstants i18nConstants) {
                return i18nConstants.statusDraft();
            }
        }
        ,
        FINAL(2){

            @Override
            public String getI18nStatus(DocumentConstants i18nConstants) {
                return i18nConstants.statusFinal();
            }
        }
        ,
        RELEASED(3){

            @Override
            public String getI18nStatus(DocumentConstants i18nConstants) {
                return i18nConstants.statusReleased();
            }
        };

        private final long _id;

        private Status(int id) {
            this._id = id;
        }

        @Override
        public long getId() {
            return this._id;
        }

        @Nonnull
        public abstract String getI18nStatus(@Nonnull DocumentConstants var1);

        @Nonnull
        public static Function<Status, String> i18nFunction(final @Nonnull DocumentConstants i18nConstants) {
            return new Function<Status, String>(){

                public String apply(Status status) {
                    return status == null ? null : status.getI18nStatus(i18nConstants);
                }
            };
        }
    }
}

