/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.design.persistence.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import de.justsoftware.onx.design.persistence.model.DBThemeAttribute;
import de.justsoftware.onx.design.shared.model.ITheme;
import de.justsoftware.onx.design.shared.model.ThemeId;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DBTheme
implements ITheme {
    private ThemeId _id;
    private String _name;
    private boolean _defaultTheme;
    private Iterable<DBThemeAttribute> _themeElements;

    public DBTheme() {
    }

    public DBTheme(@Nullable String name) {
        this._name = name;
    }

    @Nonnull
    public static DBTheme copyOf(@Nonnull ITheme origin) {
        DBTheme copy = new DBTheme();
        copy.setId(origin.getId());
        copy.setName(origin.getName());
        copy.setThemeElements((Iterable<DBThemeAttribute>)FluentIterable.from(origin.getThemeAttributes()).transform(DBThemeAttribute.FROM_ITHEME_ELEMENT).filter(Predicates.notNull()));
        return copy;
    }

    @Override
    public ThemeId getId() {
        return this._id;
    }

    public void setId(@Nullable ThemeId id) {
        this._id = id;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void setName(@Nullable String name) {
        this._name = name;
    }

    public Iterable<DBThemeAttribute> getThemeAttributes() {
        return this._themeElements != null ? this._themeElements : ImmutableList.of();
    }

    public void setThemeElements(@Nonnull Iterable<DBThemeAttribute> themeElements) {
        this._themeElements = themeElements;
    }

    @Override
    public boolean isDefaultTheme() {
        return this._defaultTheme;
    }

    public void setDefaultTheme(boolean defaultTheme) {
        this._defaultTheme = defaultTheme;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this._id).add("name", (Object)this._name).add("themeElements", this._themeElements == null ? null : Integer.valueOf(Iterables.size(this._themeElements))).toString();
    }
}

